/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXList;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;

public final class DialogFonts
extends BaseXDialog {
    private static final String[] SIZES = new String[]{"7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "22", "24", "26", "28", "30", "33", "36", "40", "48", "64", "96"};
    private static DialogFonts dialog;
    private String[] monoFonts;
    private final BaseXList font;
    private final BaseXList font2;
    private final BaseXList size;
    private final BaseXCheckBox onlyMono;
    private final BaseXCombo antiAlias;

    private DialogFonts(GUI gui) {
        super(gui, Text.CHOOSE_FONT, false);
        GUIOptions gopts = gui.gopts;
        this.antiAlias = new BaseXCombo((BaseXWindow)this, "System", "GASP", "On", "Off");
        this.antiAlias.setSelectedItem(gopts.get(GUIOptions.ANTIALIAS));
        BaseXBack p = new BaseXBack(new TableLayout(2, 3, 8, 8));
        String[] fonts = GUIConstants.fonts();
        this.font = new BaseXList((BaseXDialog)this, fonts);
        this.font.setWidth(250);
        p.add(this.font);
        this.font2 = new BaseXList((BaseXDialog)this, fonts);
        this.font2.setWidth(250);
        p.add(this.font2);
        this.size = new BaseXList((BaseXDialog)this, SIZES);
        this.size.setWidth(50);
        p.add(this.size);
        this.font.setValue(gopts.get(GUIOptions.FONT));
        this.font2.setValue(gopts.get(GUIOptions.MONOFONT));
        this.font2.setEnabled(false);
        this.font.setValue(gopts.get(GUIOptions.FONT));
        BaseXBack pp = new BaseXBack(new TableLayout(1, 2, 8, 8));
        pp.add(new BaseXLabel("Anti-Aliasing"));
        pp.add(this.antiAlias);
        p.add(pp);
        this.onlyMono = new BaseXCheckBox(this, "Monospace", GUIOptions.LISTMONO, gopts);
        p.add(this.onlyMono);
        this.set(p, "Center");
        this.finish();
        this.monoFonts = GUIConstants.monoFonts();
        this.action(this.onlyMono);
    }

    public static void show(GUI gui) {
        if (dialog == null) {
            dialog = new DialogFonts(gui);
        }
        dialog.setVisible(true);
        DialogFonts.dialog.size.setValue(Integer.toString(gui.gopts.get(GUIOptions.FONTSIZE)));
    }

    @Override
    public void action(Object cmp) {
        int num;
        boolean changed = false;
        GUIOptions gopts = this.gui.gopts;
        if (cmp == this.antiAlias) {
            gopts.set(GUIOptions.ANTIALIAS, this.antiAlias.getSelectedItem());
            changed = true;
        } else if (cmp == this.onlyMono) {
            boolean selected = this.onlyMono.isSelected();
            gopts.set(GUIOptions.LISTMONO, selected);
            if (selected) {
                String[] stringArray;
                boolean ready = this.monoFonts != null;
                this.font2.setEnabled(ready);
                if (ready) {
                    stringArray = this.monoFonts;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = Text.PLEASE_WAIT_D;
                }
                this.font2.setData(stringArray);
            } else {
                this.font2.setEnabled(true);
                this.font2.setData(GUIConstants.fonts());
            }
            this.font2.setValue(gopts.get(GUIOptions.MONOFONT));
        } else if (cmp == this.font) {
            String name = this.font.getValue();
            if (!name.isEmpty()) {
                gopts.set(GUIOptions.FONT, name);
                changed = true;
            }
        } else if (cmp == this.font2) {
            String name = this.font2.getValue();
            if (!name.isEmpty()) {
                gopts.set(GUIOptions.MONOFONT, name);
                changed = true;
            }
        } else if (cmp == this.size && (num = this.size.getNum()) > 0) {
            gopts.set(GUIOptions.FONTSIZE, num);
            changed = true;
        }
        if (changed) {
            this.font.setFont(gopts.get(GUIOptions.FONT));
            this.font2.setFont(gopts.get(GUIOptions.MONOFONT));
            this.gui.updateLayout();
        }
    }
}

