/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.Namespaces;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.Table;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

final class NSNode {
    private NSNode[] nodes;
    private int size;
    private NSNode parent;
    private int[] values;
    private int pre;

    NSNode(int pre) {
        this.pre = pre;
        this.values = new int[0];
        this.nodes = new NSNode[0];
    }

    NSNode(DataInput in, NSNode parent) throws IOException {
        this.parent = parent;
        this.pre = in.readNum();
        this.values = in.readNums();
        this.size = in.readNum();
        this.nodes = new NSNode[this.size];
        for (int n = 0; n < this.size; ++n) {
            this.nodes[n] = new NSNode(in, this);
        }
    }

    void write(DataOutput out) throws IOException {
        out.writeNum(this.pre);
        out.writeNums(this.values);
        out.writeNum(this.size);
        for (int c = 0; c < this.size; ++c) {
            this.nodes[c].write(out);
        }
    }

    NSNode child(int i) {
        return this.nodes[i];
    }

    int children() {
        return this.size;
    }

    int pre() {
        return this.pre;
    }

    NSNode parent() {
        return this.parent;
    }

    int[] values() {
        return this.values;
    }

    NSNode find(int p, Data data) {
        int s = this.find(p);
        if (s == -1) {
            return this;
        }
        NSNode ch = this.nodes[s];
        int cp = ch.pre;
        if (cp == p) {
            return ch;
        }
        if (cp + data.size(cp, 1) <= p) {
            return this;
        }
        return this.nodes[s].find(p, data);
    }

    int find(int p) {
        int l = 0;
        int h = this.size - 1;
        while (l <= h) {
            int m = l + h >>> 1;
            int v = this.nodes[m].pre;
            if (v == p) {
                return m;
            }
            if (v < p) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return l - 1;
    }

    int uri(int prefix) {
        int[] vls = this.values;
        int vl = vls.length;
        for (int v = 0; v < vl; v += 2) {
            if (vls[v] != prefix) continue;
            return vls[v + 1];
        }
        return 0;
    }

    void delete(int p, int s) {
        int sz = this.size;
        int i = this.find(p);
        if (i == -1 || this.nodes[i].pre != p) {
            ++i;
        }
        int upper = p + s;
        int num = 0;
        int n = i;
        while (n < sz && this.nodes[n].pre < upper) {
            ++n;
            ++num;
        }
        this.size -= num;
        if (this.size == 0) {
            this.nodes = new NSNode[0];
        } else if (num > 0) {
            Array.remove(this.nodes, i, num, sz);
            for (n = this.size; n < sz; ++n) {
                this.nodes[n] = null;
            }
        }
    }

    void add(NSNode node) {
        int i;
        if (this.size == this.nodes.length) {
            this.nodes = Array.copy(this.nodes, new NSNode[Array.newCapacity(this.size)]);
        }
        if ((i = this.find(node.pre)) < 0 || node.pre != this.nodes[i].pre) {
            ++i;
        }
        Array.insert(this.nodes, i, 1, this.size++, null);
        this.nodes[i] = node;
        node.parent = this;
    }

    void add(int prefix, int uri) {
        int v = this.values.length;
        this.values = Arrays.copyOf(this.values, v + 2);
        this.values[v] = prefix;
        this.values[v + 1] = uri;
    }

    void delete(int uri) {
        for (int c = 0; c < this.size; ++c) {
            this.nodes[c].delete(uri);
        }
        int vl = this.values.length;
        for (int v = 0; v < vl; v += 2) {
            if (this.values[v + 1] != uri) continue;
            int[] vals = new int[vl - 2];
            Array.copy(this.values, v, vals);
            Array.copy(this.values, v + 2, vl - v - 2, vals, v);
            this.values = vals;
            break;
        }
    }

    void decrementPre(int start, int diff) {
        if (this.pre >= start + diff) {
            this.pre -= diff;
        }
        for (int c = 0; c < this.size; ++c) {
            this.nodes[c].decrementPre(start, diff);
        }
    }

    void incrementPre(int diff) {
        this.pre += diff;
    }

    private void print(TokenBuilder tb, int level, Namespaces ns, int start, int end) {
        if (this.pre >= start && this.pre <= end) {
            tb.add(Text.NL);
            for (int i = 0; i < level; ++i) {
                tb.add("  ");
            }
            tb.add(this).add(32);
            int[] vls = this.values;
            int vl = vls.length;
            for (int i = 0; i < vl; i += 2) {
                if (i != 0) {
                    tb.add(32);
                }
                tb.add("xmlns");
                byte[] p = ns.prefix(vls[i]);
                if (p.length != 0) {
                    tb.add(58);
                }
                tb.add(p).add("=\"").add(ns.uri(vls[i + 1])).add(34);
            }
        }
        for (int c = 0; c < this.size; ++c) {
            this.nodes[c].print(tb, level + 1, ns, start, end);
        }
    }

    void table(Table table, int start, int end, Namespaces ns) {
        int i;
        int vl = this.values.length;
        for (i = 0; i < vl; i += 2) {
            if (this.pre < start || this.pre > end) continue;
            TokenList tl = new TokenList();
            tl.add(this.values[i + 1]);
            tl.add(this.pre);
            tl.add(this.pre - this.parent.pre);
            tl.add(ns.prefix(this.values[i]));
            tl.add(ns.uri(this.values[i + 1]));
            table.contents.add(tl);
        }
        for (i = 0; i < this.size; ++i) {
            this.nodes[i].table(table, start, end, ns);
        }
    }

    void info(TokenObjMap<TokenList> map, Namespaces ns) {
        int vl = this.values.length;
        for (int v = 0; v < vl; v += 2) {
            byte[] prefix = ns.prefix(this.values[v]);
            byte[] uri = ns.uri(this.values[v + 1]);
            TokenList prfs = map.computeIfAbsent(uri, () -> new TokenList(1L));
            if (prfs.contains(prefix)) continue;
            prfs.add(prefix);
        }
        for (int c = 0; c < this.size; ++c) {
            this.nodes[c].info(map, ns);
        }
    }

    String toString(Namespaces ns, int start, int end) {
        TokenBuilder tb = new TokenBuilder();
        this.print(tb, 0, ns, start, end);
        return tb.toString();
    }

    public String toString() {
        return "Pre[" + this.pre + "]";
    }
}

