/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.AlterBackup;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.AlterPassword;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.BinaryGet;
import org.basex.core.cmd.BinaryPut;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Dir;
import org.basex.core.cmd.DropBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.DropIndex;
import org.basex.core.cmd.DropUser;
import org.basex.core.cmd.Execute;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Flush;
import org.basex.core.cmd.Get;
import org.basex.core.cmd.Grant;
import org.basex.core.cmd.Help;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.InfoIndex;
import org.basex.core.cmd.InfoStorage;
import org.basex.core.cmd.Inspect;
import org.basex.core.cmd.Kill;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.core.cmd.Password;
import org.basex.core.cmd.Put;
import org.basex.core.cmd.Rename;
import org.basex.core.cmd.RepoDelete;
import org.basex.core.cmd.RepoInstall;
import org.basex.core.cmd.RepoList;
import org.basex.core.cmd.Restore;
import org.basex.core.cmd.Run;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.ShowBackups;
import org.basex.core.cmd.ShowOptions;
import org.basex.core.cmd.ShowSessions;
import org.basex.core.cmd.ShowUsers;
import org.basex.core.cmd.Test;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.Commands;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.similarity.Levenshtein;

final class StringParser
extends CommandParser {
    private InputParser parser;

    StringParser(String input, Context context) {
        super(input, context);
    }

    @Override
    protected void parse(ArrayList<Command> cmds) throws QueryException {
        Scanner sc = new Scanner(this.input).useDelimiter(this.single ? "\u0000" : "\r\n?|\n");
        while (sc.hasNext()) {
            String line = sc.next().trim();
            if (line.isEmpty() || Strings.startsWith(line, '#')) continue;
            this.parser = new InputParser(line);
            this.parser.file = this.uri;
            while (this.parser.more()) {
                Commands.Cmd cmd = this.consume(Commands.Cmd.class, null);
                if (cmd != null) {
                    cmds.add(this.parse(cmd).baseURI(this.uri));
                }
                if (!this.parser.more() || this.parser.consume(59)) continue;
                throw this.help(null, cmd);
            }
        }
    }

    private Command parse(Commands.Cmd cmd) throws QueryException {
        switch (cmd) {
            case CREATE: {
                switch (this.consume(Commands.CmdCreate.class, cmd)) {
                    case BACKUP: {
                        return new CreateBackup(this.glob(null), this.string(null));
                    }
                    case DATABASE: 
                    case DB: {
                        return new CreateDB(this.name(cmd), this.remaining(null, true));
                    }
                    case INDEX: {
                        return new CreateIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    }
                    case USER: {
                        return new CreateUser(this.name(cmd), this.password());
                    }
                }
                break;
            }
            case COPY: {
                return new Copy(this.name(cmd), this.name(cmd));
            }
            case ALTER: {
                switch (this.consume(Commands.CmdAlter.class, cmd)) {
                    case BACKUP: {
                        return new AlterBackup(this.name(cmd), this.name(cmd));
                    }
                    case DATABASE: 
                    case DB: {
                        return new AlterDB(this.name(cmd), this.name(cmd));
                    }
                    case PASSWORD: {
                        return new AlterPassword(this.name(cmd), this.password());
                    }
                    case USER: {
                        return new AlterUser(this.name(cmd), this.name(cmd));
                    }
                }
                break;
            }
            case OPEN: {
                return new Open(this.name(cmd));
            }
            case CHECK: {
                return new Check(this.string(cmd));
            }
            case ADD: {
                String aa = this.key("TO", null) ? this.string(cmd) : null;
                return new Add(aa, this.remaining(cmd, true));
            }
            case GET: {
                return new Get(this.string(cmd));
            }
            case BINARY: {
                switch (this.consume(Commands.CmdBinary.class, cmd)) {
                    case GET: {
                        return new BinaryGet(this.string(cmd));
                    }
                    case PUT: {
                        String sa = this.key("TO", null) ? this.string(cmd) : null;
                        return new BinaryPut(sa, this.remaining(cmd, true));
                    }
                }
                break;
            }
            case DELETE: {
                return new Delete(this.string(cmd));
            }
            case RENAME: {
                return new Rename(this.string(cmd), this.string(cmd));
            }
            case PUT: {
                return new Put(this.string(cmd), this.remaining(cmd, true));
            }
            case INFO: {
                switch (this.consume(Commands.CmdInfo.class, cmd)) {
                    case NULL: {
                        return new Info();
                    }
                    case DATABASE: 
                    case DB: {
                        return new InfoDB();
                    }
                    case INDEX: {
                        return new InfoIndex((Object)this.consume(Commands.CmdIndexInfo.class, null));
                    }
                    case STORAGE: {
                        String arg1 = this.number();
                        String arg2 = arg1 != null ? this.number() : null;
                        return new InfoStorage(arg1, arg2);
                    }
                }
                break;
            }
            case INSPECT: {
                return new Inspect();
            }
            case CLOSE: {
                return new Close();
            }
            case LIST: {
                return new List(this.name(null), this.string(null));
            }
            case DIR: {
                return new Dir(this.string(null));
            }
            case DROP: {
                switch (this.consume(Commands.CmdDrop.class, cmd)) {
                    case DATABASE: 
                    case DB: {
                        return new DropDB(this.glob(cmd));
                    }
                    case INDEX: {
                        return new DropIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    }
                    case USER: {
                        return new DropUser(this.glob(cmd), this.key("ON", null) ? this.glob(cmd) : null);
                    }
                    case BACKUP: {
                        return new DropBackup(this.glob(null));
                    }
                }
                break;
            }
            case OPTIMIZE: {
                switch (this.consume(Commands.CmdOptimize.class, cmd)) {
                    case NULL: {
                        return new Optimize();
                    }
                    case ALL: {
                        return new OptimizeAll();
                    }
                }
                break;
            }
            case EXPORT: {
                return new Export(this.string(cmd));
            }
            case XQUERY: {
                return new XQuery(this.remaining(cmd, false));
            }
            case RUN: {
                return new Run(this.string(cmd));
            }
            case TEST: {
                return new Test(this.string(cmd));
            }
            case EXECUTE: {
                return new Execute(this.remaining(cmd, true));
            }
            case FIND: {
                return new Find(this.remaining(cmd, true));
            }
            case SET: {
                return new Set(this.name(cmd), (Object)this.remaining(null, true));
            }
            case PASSWORD: {
                return new Password(this.password());
            }
            case HELP: {
                return new Help(this.name(null));
            }
            case EXIT: 
            case QUIT: {
                return new Exit();
            }
            case FLUSH: {
                return new Flush();
            }
            case KILL: {
                return new Kill(this.string(cmd));
            }
            case RESTORE: {
                return new Restore(this.name(null));
            }
            case SHOW: {
                switch (this.consume(Commands.CmdShow.class, cmd)) {
                    case SESSIONS: {
                        return new ShowSessions();
                    }
                    case USERS: {
                        return new ShowUsers(this.key("ON", null) ? this.name(cmd) : null);
                    }
                    case BACKUPS: {
                        return new ShowBackups();
                    }
                    case OPTIONS: {
                        return new ShowOptions(this.name(null));
                    }
                }
                break;
            }
            case GRANT: {
                Commands.CmdPerm perm = this.consume(Commands.CmdPerm.class, cmd);
                if (perm == null) {
                    throw this.help(null, cmd);
                }
                String db = this.key("ON", null) ? this.glob(cmd) : null;
                this.key("TO", cmd);
                return new Grant((Object)perm, this.glob(cmd), db);
            }
            case REPO: {
                switch (this.consume(Commands.CmdRepo.class, cmd)) {
                    case INSTALL: {
                        return new RepoInstall(this.string(cmd), new InputInfo(this.parser));
                    }
                    case DELETE: {
                        return new RepoDelete(this.string(cmd), new InputInfo(this.parser));
                    }
                    case LIST: {
                        return new RepoList();
                    }
                }
            }
        }
        throw Util.notExpected("Command specified, but not implemented yet", new Object[0]);
    }

    private String string(Commands.Cmd cmd) throws QueryException {
        StringBuilder sb = new StringBuilder();
        this.consumeWS();
        boolean more = true;
        boolean quoted = false;
        while (more && this.parser.more()) {
            char ch = this.parser.curr();
            if (quoted) {
                if (ch == '\"') {
                    more = false;
                }
            } else {
                if (ch <= ' ' || this.eoc()) break;
                if (ch == '\"' && sb.length() == 0) {
                    quoted = true;
                }
            }
            sb.append(this.parser.consume());
        }
        return this.finish(sb.toString().replaceAll("^\"|\"$", ""), cmd);
    }

    private String remaining(Commands.Cmd cmd, boolean quotes) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        while (this.parser.more()) {
            sb.append(this.parser.consume());
        }
        String str = sb.toString();
        return this.finish(quotes ? str.replaceAll("^\"|\"$", "") : str, cmd);
    }

    private String command() throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        while (!this.eoc() && !Token.ws(this.parser.curr())) {
            sb.append(this.parser.consume());
        }
        return this.finish(sb, null);
    }

    private String name(Commands.Cmd cmd) throws QueryException {
        return this.name(cmd, false);
    }

    private String password() throws QueryException {
        String pw = this.string(null);
        return pw != null ? pw : (this.pwReader == null ? "" : this.pwReader.password());
    }

    private String glob(Commands.Cmd cmd) throws QueryException {
        return this.name(cmd, true);
    }

    private String name(Commands.Cmd cmd, boolean glob) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char ch;
        while (Databases.validChar(ch = this.parser.curr(), sb.length() == 0) || glob && (ch == '*' || ch == '?' || ch == ',')) {
            sb.append(this.parser.consume());
            last = ch;
        }
        return this.finish((this.eoc() || Token.ws(ch)) && last != '.' ? sb : null, cmd);
    }

    private boolean key(String key, Commands.Cmd cmd) throws QueryException {
        boolean ok;
        this.consumeWS();
        int p = this.parser.pos;
        boolean bl = ok = !(!this.parser.consume(key) && !this.parser.consume(key.toLowerCase(Locale.ENGLISH)) || !this.parser.curr(0) && !Token.ws(this.parser.curr()));
        if (!ok) {
            this.parser.pos = p;
            if (cmd != null) {
                throw this.help(null, cmd);
            }
        }
        return ok;
    }

    private String finish(CharSequence string, Commands.Cmd cmd) throws QueryException {
        if (string != null && string.length() != 0) {
            return string.toString();
        }
        if (cmd != null) {
            throw this.help(null, cmd);
        }
        return null;
    }

    private String number() throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        if (this.parser.curr() == '-') {
            sb.append(this.parser.consume());
        }
        while (Token.digit(this.parser.curr())) {
            sb.append(this.parser.consume());
        }
        return this.finish(this.eoc() || Token.ws(this.parser.curr()) ? sb : null, null);
    }

    private void consumeWS() {
        int pl = this.parser.length;
        while (this.parser.pos < pl && this.parser.input.charAt(this.parser.pos) <= ' ') {
            ++this.parser.pos;
        }
        this.parser.mark = this.parser.pos - 1;
    }

    private <E extends Enum<E>> E consume(Class<E> complete, Commands.Cmd parent) throws QueryException {
        String token = this.command();
        if (!this.suggest || token == null || !token.isEmpty()) {
            try {
                return Enum.valueOf(complete, token == null ? "NULL" : token.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
            }
        }
        Enum<?>[] alt = StringParser.startWith(complete, token);
        if (token == null) {
            if (parent != null) {
                throw this.help(alt, parent);
            }
            if (this.suggest) {
                throw this.error(alt, Text.EXPECTING_CMD, new Object[0]);
            }
            return null;
        }
        byte[] name = Token.uc(Token.token(token));
        Object similar = Levenshtein.similar(name, StringParser.startWith(complete, null), o -> ((Enum)o).name());
        if (similar != null) {
            throw this.error(alt, Text.UNKNOWN_SIMILAR_X_X, name, similar);
        }
        throw parent == null ? this.error(alt, Text.UNKNOWN_TRY_X, token) : this.help(alt, parent);
    }

    private QueryException help(Enum<?>[] alt, Commands.Cmd cmd) {
        return this.error(alt, Text.SYNTAX + ": " + cmd.help(true), new Object[0]);
    }

    private static <T extends Enum<T>> Enum<?>[] startWith(Class<T> en, String prefix) {
        Enum[] list = new Enum[]{};
        String t = prefix == null ? "" : prefix.toUpperCase(Locale.ENGLISH);
        for (Enum e : (Enum[])en.getEnumConstants()) {
            if (!e.name().startsWith(t)) continue;
            int s = list.length;
            list = Array.copy(list, new Enum[s + 1]);
            list[s] = e;
        }
        return list;
    }

    private boolean eoc() {
        return !this.parser.more() || this.parser.curr() == ';';
    }

    private QueryException error(Enum<?>[] complete, String msg, Object ... ext) {
        this.completions = complete;
        return new QueryException(this.parser.info(), QNm.EMPTY, msg, ext).suggest(this.parser);
    }
}

