/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.QueryJobResult;
import org.basex.core.jobs.QueryJobTask;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class JobPool {
    static final int MAXQUERIES = 1000;
    public final Map<String, Job> active = new ConcurrentHashMap<String, Job>();
    public final Map<String, QueryJobResult> results = new ConcurrentHashMap<String, QueryJobResult>();
    public final Map<String, QueryJobTask> tasks = new ConcurrentHashMap<String, QueryJobTask>();
    final Timer timer = new Timer(true);
    private final long timeout;

    public JobPool(StaticOptions sopts) {
        this.timeout = (long)sopts.get(StaticOptions.CACHETIMEOUT).intValue() * 1000L;
    }

    public void register(Job job) {
        while (this.active.size() >= 1000) {
            Performance.sleep(1L);
        }
        this.active.put(job.jc().id(), job);
    }

    public void unregister(Job job) {
        this.active.remove(job.jc().id());
    }

    public synchronized void close() {
        this.timer.cancel();
        for (Job job : this.active.values()) {
            job.stop();
        }
        while (!this.active.isEmpty()) {
            Performance.sleep(1L);
        }
    }

    public void scheduleResult(final Job job) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                JobPool.this.results.remove(job.jc().id());
            }
        }, this.timeout);
    }

    public TokenList ids() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.results.keySet());
        set.addAll(this.active.keySet());
        set.addAll(this.tasks.keySet());
        TokenList ids = new TokenList(set.size());
        for (String id : set) {
            ids.add(id);
        }
        byte[] prefix = Token.token("job");
        int pl = prefix.length;
        return (TokenList)ids.sort((id1, id2) -> Token.startsWith(id1, prefix) && Token.startsWith(id2, prefix) ? Token.toInt(Token.substring(id1, pl)) - Token.toInt(Token.substring(id2, pl)) : Token.diff(id1, id2), true);
    }

    public boolean remove(String id) {
        Job job;
        TimerTask task = this.tasks.remove(id);
        if (task != null) {
            task.cancel();
        }
        if ((job = this.active.get(id)) != null) {
            job.stop();
        }
        this.results.remove(id);
        return job != null || task != null;
    }
}

