/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class Rename
extends ACreate {
    public Rename(String source, String target) {
        super(Perm.WRITE, true, source, target);
    }

    @Override
    protected boolean run() {
        Data data = this.context.data();
        String src = MetaData.normPath(this.args[0]);
        if (src == null) {
            return this.error(Text.NAME_INVALID_X, this.args[0]);
        }
        String trg = MetaData.normPath(this.args[1]);
        if (trg == null) {
            return this.error(Text.NAME_INVALID_X, this.args[1]);
        }
        return this.update(data, () -> this.rename(data, src, trg));
    }

    private boolean rename(Data data, String src, String trg) {
        boolean ok = true;
        int c = 0;
        if (!IO.equals(src, trg)) {
            IntList docs = data.resources.docs(src);
            int ds = docs.size();
            for (int i = 0; i < ds; ++i) {
                int pre = docs.get(i);
                String target = Rename.target(data, pre, src, trg);
                if (target.isEmpty()) {
                    ok = !this.info(Text.NAME_INVALID_X, target);
                    continue;
                }
                data.update(pre, 0, Token.token(target));
                ++c;
            }
            for (ResourceType type : Resources.BINARIES) {
                IOFile source = data.meta.file(src, type);
                if (source == null || !source.exists()) continue;
                IOFile target = data.meta.file(trg, type);
                IOFile trgdir = target.parent();
                if (!trgdir.md() || !source.rename(target)) {
                    ok = !this.info(Text.NAME_INVALID_X, trg);
                }
                ++c;
            }
        }
        return this.info(Text.RES_RENAMED_X_X, c, this.jc().performance) && ok;
    }

    public static String target(Data data, int pre, String src, String trg) {
        String path = Token.string(data.text(pre, true));
        if (IO.equals(path, src)) {
            return trg;
        }
        String source = src.isEmpty() || Strings.endsWith(src, '/') ? src : src + "/";
        String target = trg.isEmpty() || Strings.endsWith(trg, '/') ? trg : trg + "/";
        return target + path.substring(source.length());
    }
}

