/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.HashSet;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class Export
extends Command {
    private IO progFile;
    private int progPos;
    private int progSize;

    public Export(String path) {
        super(Perm.CREATE, true, path);
    }

    @Override
    protected boolean run() {
        try {
            Data data = this.context.data();
            Export.export(data, this.args[0], this.options, this);
            return this.info(Text.DB_EXPORTED_X, data.meta.name, this.jc().performance);
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("internal:context");
    }

    public static void export(Data data, String path, MainOptions options, Export export) throws IOException {
        Export.export(data, path, options.get(MainOptions.EXPORTER), export);
    }

    public static void export(Data data, String path, SerializerOptions sopts, Export export) throws IOException {
        IOFile io;
        StringList files;
        IOFile source;
        IOFile root = new IOFile(path);
        root.md();
        IntList docs = data.resources.docs();
        if (data.inMemory()) {
            source = null;
            files = new StringList();
        } else {
            source = data.meta.dir(ResourceType.BINARY);
            files = source.descendants();
        }
        if (export != null) {
            export.progPos = 0;
            export.progSize = docs.size() + files.size();
        }
        HashSet<String> target = new HashSet<String>();
        int is = docs.size();
        for (int i = 0; i < is; ++i) {
            int pre = docs.get(i);
            io = root.resolve(Token.string(data.text(pre, true)));
            if (export != null) {
                export.checkStop();
                export.progFile = io;
            }
            io.parent().md();
            try (PrintOutput po = new PrintOutput(Export.unique(target, io.path()));
                 Serializer ser = Serializer.get(po, sopts);){
                ser.serialize(new DBNode(data, pre));
            }
            if (export == null) continue;
            ++export.progPos;
        }
        for (String file : files) {
            io = new IOFile(root.path(), file);
            if (export != null) {
                export.checkStop();
                export.progFile = io;
            }
            new IOFile(source, file).copyTo(Export.unique(target, io.path()));
            if (export == null) continue;
            ++export.progPos;
        }
    }

    @Override
    public double progressInfo() {
        return this.progSize == 0 ? 0.0 : (double)this.progPos / (double)this.progSize;
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public String shortInfo() {
        return Text.EXPORT + "...";
    }

    @Override
    public String detailedInfo() {
        return this.progFile == null ? Text.EXPORT : "(" + this.progPos + "/" + this.progSize + "): " + this.progFile;
    }

    private static IOFile unique(HashSet<String> exp, String file) {
        int c = 1;
        Object path = file;
        while (exp.contains(path)) {
            path = file.indexOf(46) == -1 ? file + "(" + ++c + ")" : file.replaceAll("(.*)\\.(.*)", "$1(" + ++c + ").$2");
        }
        exp.add((String)path);
        return new IOFile((String)path);
    }
}

