/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Text;
import org.basex.core.cmd.AUser;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.User;
import org.basex.core.users.Users;
import org.basex.server.ClientListener;

public final class DropUser
extends AUser {
    public DropUser(String name) {
        this(name, (String)null);
    }

    public DropUser(String name, String pattern) {
        super(name, pattern == null ? "" : pattern);
    }

    @Override
    protected boolean run() {
        return this.run(0, true);
    }

    @Override
    protected boolean run(String name, String db) {
        if (name.equals("admin")) {
            return !this.info(Text.ADMIN_STATIC, new Object[0]);
        }
        Users users = this.context.users;
        User user = users.get(name);
        if (user != null) {
            if (db.isEmpty()) {
                for (ClientListener cl : this.context.sessions) {
                    if (!cl.context().user().name().equals(name)) continue;
                    return !this.info(Text.USER_LOGGED_IN_X, name);
                }
                users.drop(user);
            } else {
                user.drop(db);
            }
            return this.info(db.isEmpty() ? Text.USER_DROPPED_X : Text.USER_DROPPED_X_X, name, db);
        }
        return true;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(Commands.Cmd.DROP + " " + Commands.CmdDrop.USER).arg(0).arg("ON", 1);
    }
}

