/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.util.list.StringList;

public final class DropBackup
extends ABackup {
    public DropBackup(String pattern) {
        super(pattern != null ? pattern : "");
    }

    @Override
    protected boolean run() {
        StringList names;
        String pattern = this.args[0];
        boolean general = pattern.isEmpty();
        if (!general && !Databases.validPattern(pattern)) {
            return this.error(Text.NAME_INVALID_X, pattern);
        }
        StringList stringList = names = general ? new StringList("") : this.context.listDBs(pattern);
        if (names.isEmpty() && this.context.perm(Perm.READ, pattern)) {
            names.add(pattern);
        }
        for (String name : names) {
            for (String backup : this.context.databases.backups(name)) {
                DropBackup.drop(backup, this.soptions);
            }
        }
        return this.info(Text.BACKUP_DROPPED_X, pattern);
    }

    public static boolean drop(String backup, StaticOptions sopts) {
        return sopts.dbPath(backup + ".zip").delete();
    }

    @Override
    public void addLocks() {
        this.addLocks(this.jc().locks.writes, 0);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(Commands.Cmd.DROP + " " + Commands.CmdDrop.BACKUP).args();
    }
}

