/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.JobException;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.users.Perm;
import org.basex.io.out.NullOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerMode;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.util.Util;

public abstract class AQuery
extends Command {
    protected final HashMap<String, Map.Entry<Object, String>> bindings = new HashMap();
    private final String query;
    private QueryProcessor qp;
    private QueryInfo info;
    private boolean plan;
    private int maxResults = -1;

    AQuery(boolean openDB, String arg, String query) {
        super(Perm.NONE, openDB, arg);
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        boolean queryinfo = this.options.get(MainOptions.QUERYINFO);
        String error = null;
        long hits = 0L;
        if (this.exception != null) {
            error = Util.message(this.exception);
        } else {
            try {
                boolean runquery = this.options.get(MainOptions.RUNQUERY);
                boolean serialize = this.options.get(MainOptions.SERIALIZE);
                boolean optplan = this.options.get(MainOptions.OPTPLAN);
                int runs = Math.max(1, this.options.get(MainOptions.RUNS));
                for (int r = 0; r < runs; ++r) {
                    if (r != 0) {
                        this.qp = null;
                        this.popJob();
                    }
                    this.init(this.context);
                    this.queryPlan(!optplan);
                    this.qp.optimize();
                    this.queryPlan(optplan);
                    if (!runquery) continue;
                    PrintOutput po = r == 0 && serialize ? this.out : new NullOutput();
                    try (Serializer ser = this.qp.serializer(po);){
                        if (this.maxResults >= 0) {
                            this.qp.cache(this, this.maxResults);
                            hits = this.result.size();
                            this.result.serialize(ser);
                            if (this.exception instanceof QueryException) {
                                throw (QueryException)this.exception;
                            }
                            if (this.exception instanceof JobException) {
                                throw (JobException)this.exception;
                            }
                        } else {
                            Item item;
                            hits = 0L;
                            Iter iter = this.qp.iter();
                            while ((item = iter.next()) != null) {
                                ser.serialize(item);
                                ++hits;
                                this.checkStop();
                            }
                        }
                    }
                    this.qp.close();
                }
            }
            catch (IOException | JobException | QueryException ex) {
                this.exception = ex;
                error = Util.message(ex);
            }
            catch (StackOverflowError ex) {
                Util.debug(ex);
                error = QueryError.BASEX_OVERFLOW.message;
            }
            catch (RuntimeException ex) {
                this.exception = ex;
            }
            finally {
                if (this.qp != null) {
                    this.qp.close();
                }
            }
        }
        this.queryPlan(true);
        this.info(this.info.toString(this.qp, this.out.size(), hits, this.jc().locks, error == null), new Object[0]);
        if (error != null) {
            return this.error((String)(queryinfo ? this.info() + Text.ERROR + ":" + Text.NL + error : error), new Object[0]);
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        return true;
    }

    public final void maxResults(int max) {
        this.maxResults = max;
    }

    public final String parameters(Context ctx) {
        try {
            this.init(ctx);
            return this.qp.qc.parameters().toString();
        }
        catch (QueryException ex) {
            this.error(Util.message(ex), new Object[0]);
            return SerializerMode.DEFAULT.get().toString();
        }
    }

    @Override
    public final boolean updating(Context ctx) {
        try {
            this.init(ctx);
            return this.qp.updating;
        }
        catch (JobException | QueryException ex) {
            this.qp.close();
            this.exception = ex;
            return false;
        }
        catch (RuntimeException ex) {
            this.qp.close();
            this.exception = ex;
            throw ex;
        }
    }

    @Override
    public final boolean updated(Context ctx) {
        return this.qp.updates() != 0;
    }

    @Override
    public final void addLocks() {
        this.qp.addLocks();
    }

    @Override
    public final void build(CmdBuilder cb) {
        cb.init().add(0);
    }

    @Override
    public final boolean stoppable() {
        return true;
    }

    private void init(Context ctx) throws QueryException {
        if (this.qp != null) {
            return;
        }
        if (this.info == null) {
            this.info = new QueryInfo(ctx);
        } else {
            this.info.reset();
        }
        this.qp = this.pushJob(new QueryProcessor(this.query, this.uri, ctx, this.info));
        for (Map.Entry<String, Map.Entry<Object, String>> entry : this.bindings.entrySet()) {
            Map.Entry<Object, String> value = entry.getValue();
            this.qp.variable(entry.getKey(), value.getKey(), value.getValue());
        }
        this.qp.parse();
        this.qp.compile();
    }

    private void queryPlan(boolean create) {
        if (create && !this.plan && this.options.get(MainOptions.XMLPLAN).booleanValue()) {
            try {
                this.info(Text.NL + Text.QUERY_PLAN + ":", new Object[0]);
                this.info(this.qp.toXml().serialize(SerializerMode.INDENT.get()).toString(), new Object[0]);
                this.plan = true;
            }
            catch (QueryIOException ex) {
                Util.stack(ex);
            }
        }
    }
}

