/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.html;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.basex.build.html.HtmlOptions;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.TextInput;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.ccil.cowan.tagsoup.Parser;
import org.ccil.cowan.tagsoup.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class HtmlParser
extends XMLParser {
    private static final String NAME = "TagSoup";
    private static final String FEATURES = "http://www.ccil.org/~cowan/tagsoup/features/";

    public static boolean available() {
        return Reflect.available("org.ccil.cowan.tagsoup.Parser", new Object[0]);
    }

    public static String parser() {
        return HtmlParser.available() ? NAME : "";
    }

    public HtmlParser(IO source, MainOptions options) throws IOException {
        this(source, options, options.get(MainOptions.HTMLPARSER));
    }

    public HtmlParser(IO source, MainOptions options, HtmlOptions hopts) throws IOException {
        super(HtmlParser.toXml(source, hopts), options);
    }

    private static IO toXml(IO io, HtmlOptions hopts) throws IOException {
        IOContent iOContent;
        if (!HtmlParser.available()) {
            return io;
        }
        TextInput ti = new TextInput(io);
        try {
            String enc = ti.encoding();
            byte[] content = ti.content();
            byte[] encoding = Token.token("charset=");
            int cs = Token.indexOf(content, encoding);
            if (cs > 0) {
                int ce = cs += encoding.length;
                int cl = content.length;
                while (++ce < cl && content[ce] > 40) {
                }
                enc = Token.string(Token.substring(content, cs, ce));
            }
            StringWriter sw = new StringWriter();
            Parser reader = new Parser();
            XMLWriter writer = new XMLWriter((Writer)sw);
            writer.setOutputProperty(HtmlOptions.ENCODING.name(), "UTF-8");
            reader.setContentHandler((ContentHandler)writer);
            if (hopts.get(HtmlOptions.HTML).booleanValue()) {
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
                writer.setOutputProperty(HtmlOptions.METHOD.name(), "html");
                writer.setOutputProperty(HtmlOptions.OMIT_XML_DECLARATION.name(), "yes");
            }
            if (hopts.get(HtmlOptions.NONS).booleanValue()) {
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
            }
            if (hopts.get(HtmlOptions.NOBOGONS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
            }
            if (hopts.get(HtmlOptions.NODEFAULTS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/default-attributes", false);
            }
            if (hopts.get(HtmlOptions.NOCOLONS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/translate-colons", true);
            }
            if (hopts.get(HtmlOptions.NORESTART).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/restart-elements", false);
            }
            if (hopts.get(HtmlOptions.IGNORABLE).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace", true);
            }
            if (hopts.get(HtmlOptions.EMPTYBOGONS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", true);
            }
            if (hopts.get(HtmlOptions.ANY).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
            }
            if (hopts.get(HtmlOptions.NOROOTBOGONS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/root-bogons", false);
            }
            if (hopts.get(HtmlOptions.NOCDATA).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/cdata-elements", false);
            }
            if (hopts.get(HtmlOptions.LEXICAL).booleanValue()) {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", writer);
            }
            if (hopts.get(HtmlOptions.OMIT_XML_DECLARATION).booleanValue()) {
                writer.setOutputProperty(HtmlOptions.OMIT_XML_DECLARATION.name(), "yes");
            }
            if (hopts.contains(HtmlOptions.METHOD)) {
                writer.setOutputProperty(HtmlOptions.METHOD.name(), hopts.get(HtmlOptions.METHOD));
            }
            if (hopts.contains(HtmlOptions.DOCTYPE_SYSTEM)) {
                writer.setOutputProperty(HtmlOptions.DOCTYPE_SYSTEM.name(), hopts.get(HtmlOptions.DOCTYPE_SYSTEM));
            }
            if (hopts.contains(HtmlOptions.DOCTYPE_PUBLIC)) {
                writer.setOutputProperty(HtmlOptions.DOCTYPE_PUBLIC.name(), hopts.get(HtmlOptions.DOCTYPE_PUBLIC));
            }
            if (hopts.contains(HtmlOptions.ENCODING)) {
                enc = hopts.get(HtmlOptions.ENCODING);
            }
            InputSource is = new InputSource(new ArrayInput(content));
            is.setEncoding(Strings.supported(enc) ? Strings.normEncoding(enc) : "UTF-8");
            reader.parse(is);
            iOContent = new IOContent(Token.token(sw.toString()), io.name());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ti.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SAXException ex) {
                Util.errln(ex, new Object[0]);
                return io;
            }
        }
        ti.close();
        return iOContent;
    }
}

