/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.SingleParser;
import org.basex.build.csv.CsvParser;
import org.basex.build.html.HtmlParser;
import org.basex.build.json.JsonParser;
import org.basex.build.xml.SAXWrapper;
import org.basex.build.xml.XMLParser;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.util.Atts;

public class Parser
extends Job {
    protected final Atts atts = new Atts();
    protected final Atts nsp = new Atts();
    protected final MainOptions options;
    protected String target = "";
    protected IO source;

    private Parser(MainOptions options) {
        this.options = options;
    }

    protected Parser(String source, MainOptions options) {
        this(IO.get(source), options);
    }

    protected Parser(IO source, MainOptions options) {
        this(options);
        this.source = source;
    }

    public void parse(Builder build) throws IOException {
        if (this.source != null) {
            throw new BaseXException("No parser available for supplied source.", new Object[0]);
        }
    }

    public void close() throws IOException {
    }

    public String info() {
        return "";
    }

    public Parser target(String path) {
        this.target = path.isEmpty() ? "" : (path + "/").replaceAll("//+", "/");
        return this;
    }

    public IO source() {
        return this.source;
    }

    public static Parser emptyParser(MainOptions options) {
        return new Parser(options);
    }

    public static SAXWrapper xmlParser(IO source) {
        return new SAXWrapper(source, new MainOptions());
    }

    public static SingleParser singleParser(IO source, MainOptions options, String target) throws IOException {
        SingleParser p;
        MainOptions.MainParser mp = options.get(MainOptions.PARSER);
        switch (mp) {
            case HTML: {
                p = new HtmlParser(source, options);
                break;
            }
            case JSON: {
                p = new JsonParser(source, options);
                break;
            }
            case CSV: {
                p = new CsvParser(source, options);
                break;
            }
            default: {
                p = options.get(MainOptions.INTPARSE) != false ? new XMLParser(source, options) : new SAXWrapper(source, options);
            }
        }
        p.target(target);
        return p;
    }
}

