/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqsequence;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import net.xqj.core.Constants;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.Logger;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemFactory;
import net.xqj.core.xqitem.XQItemProxy;
import net.xqj.core.xqsequence.XQSequenceBase;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class XQSequenceProxy
implements XQSequence,
Cloneable {
    protected static int instanceCounter = 0;
    protected int instanceId = ++instanceCounter;
    protected static final Logger EMPTY_LOGGER_INSTANCE = Constants.EMPTY_LOGGER_INSTANCE;
    protected XQSequenceBase sequence = null;
    protected boolean isClosed = false;
    protected Logger logger = EMPTY_LOGGER_INSTANCE;

    protected XQSequenceProxy() {
    }

    protected XQSequenceProxy(XQSequenceBase sequence) {
        this.sequence = sequence;
    }

    static XQSequenceProxy newInstance(XQSequenceBase sequence) {
        return new XQSequenceProxy(sequence);
    }

    static XQSequenceProxy newInstance() {
        return new XQSequenceProxy();
    }

    public boolean absolute(int i) throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(39, this, new Integer(i)));
        }
        return this.sequence.absolute(i);
    }

    public void afterLast() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(40, this));
        }
        this.sequence.afterLast();
    }

    public void beforeFirst() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(41, this));
        }
        this.sequence.beforeFirst();
    }

    public void close() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(42, this));
        }
        this.isClosed = true;
        this.sequence.close();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int count() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(43, this));
        }
        return this.sequence.count();
    }

    public int getPosition() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(44, this));
        }
        return this.sequence.getPosition();
    }

    public boolean isOnItem() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(45, this));
        }
        return this.sequence.isOnItem();
    }

    public boolean isScrollable() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(46, this));
        }
        return this.sequence.isScrollable();
    }

    public boolean first() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(47, this));
        }
        return this.sequence.first();
    }

    public XQItem getItem() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(48, this));
        }
        XQItemBase itemBase = (XQItemBase)this.sequence.getItem();
        XQItemProxy itemProxy = XQItemFactory.newXQItemProxy(itemBase);
        itemProxy.setSequence(this);
        return itemProxy;
    }

    public XMLStreamReader getSequenceAsStream() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(49, this));
        }
        return this.sequence.getSequenceAsStream();
    }

    public String getSequenceAsString(Properties properties) throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(50, this, properties));
        }
        return this.sequence.getSequenceAsString(properties);
    }

    public boolean isAfterLast() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(51, this));
        }
        return this.sequence.isAfterLast();
    }

    public boolean isBeforeFirst() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(52, this));
        }
        return this.sequence.isBeforeFirst();
    }

    public boolean isFirst() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(53, this));
        }
        return this.sequence.isFirst();
    }

    public boolean isLast() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(54, this));
        }
        return this.sequence.isLast();
    }

    public boolean last() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(55, this));
        }
        return this.sequence.last();
    }

    public boolean next() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(56, this));
        }
        return this.sequence.next();
    }

    public boolean previous() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(57, this));
        }
        return this.sequence.previous();
    }

    public boolean relative(int i) throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(58, this, new Integer(i)));
        }
        return this.sequence.relative(i);
    }

    public void writeSequence(OutputStream out, Properties properties) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(out, "OutputStream", "XQJSQP003");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(59, this, out, properties));
        }
        this.sequence.writeSequence(out, properties);
    }

    public void writeSequence(Writer writer, Properties properties) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(writer, "Writer", "XQJSQP004");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(60, this, writer, properties));
        }
        this.sequence.writeSequence(writer, properties);
    }

    public void writeSequenceToSAX(ContentHandler saxhdlr) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(saxhdlr, "ContentHandler", "XQJSQP005");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(61, this, saxhdlr));
        }
        this.sequence.writeSequenceToSAX(saxhdlr);
    }

    public void writeSequenceToResult(Result result) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(result, "Result", "XQJSQP006");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(62, this, result));
        }
        this.sequence.writeSequenceToResult(result);
    }

    public boolean getBoolean() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(63, this));
        }
        return this.sequence.getBoolean();
    }

    public byte getByte() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(64, this));
        }
        return this.sequence.getByte();
    }

    public double getDouble() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(65, this));
        }
        return this.sequence.getDouble();
    }

    public float getFloat() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(66, this));
        }
        return this.sequence.getFloat();
    }

    public int getInt() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(67, this));
        }
        return this.sequence.getInt();
    }

    public XQItemType getItemType() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(68, this));
        }
        return this.sequence.getItemType();
    }

    public String getAtomicValue() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(69, this));
        }
        return this.sequence.getAtomicValue();
    }

    public long getLong() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(70, this));
        }
        return this.sequence.getLong();
    }

    public Node getNode() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(71, this));
        }
        return this.sequence.getNode();
    }

    public URI getNodeUri() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(72, this));
        }
        if (this.isOnItem()) {
            return this.sequence.getNodeUri();
        }
        throw new XQExceptionImpl("Can not call getNodeUri() when the Sequence is not on an item.", "XQJSQP002");
    }

    public Object getObject() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(73, this));
        }
        return this.sequence.getObject();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(74, this));
        }
        return this.sequence.getItemAsStream();
    }

    public String getItemAsString(Properties properties) throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(75, this, properties));
        }
        return this.sequence.getItemAsString(properties);
    }

    public short getShort() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(76, this));
        }
        return this.sequence.getShort();
    }

    public boolean instanceOf(XQItemType xqItemType) throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(77, this, xqItemType));
        }
        return this.sequence.instanceOf(xqItemType);
    }

    public void writeItem(OutputStream out, Properties properties) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(out, "OutputStream", "XQJSQP007");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(78, this, out, properties));
        }
        this.sequence.writeItem(out, properties);
    }

    public void writeItem(Writer writer, Properties properties) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(writer, "Writer", "XQJSQP008");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(79, this, writer, properties));
        }
        this.sequence.writeItem(writer, properties);
    }

    public void writeItemToSAX(ContentHandler saxhdlr) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(saxhdlr, "ContentHandler", "XQJSQP009");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(80, this, saxhdlr));
        }
        this.sequence.writeItemToSAX(saxhdlr);
    }

    public void writeItemToResult(Result result) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(result, "Result", "XQJSQP010");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(81, this, result));
        }
        this.sequence.writeItemToResult(result);
    }

    public XQSequenceBase getSequenceBase() {
        return this.sequence;
    }

    public void isClosedCheck() throws XQException {
        if (this.isClosed()) {
            throw new XQExceptionImpl("Can not perform this operation when the sequence is closed.", "XQJSQP001");
        }
    }

    public String toString() {
        return "XQSequenceProxy-" + this.instanceId + "-(" + this.sequence + ")";
    }

    public Object clone() {
        try {
            XQSequenceProxy newProxy = (XQSequenceProxy)super.clone();
            newProxy.instanceId = ++instanceCounter;
            return newProxy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset(XQSequenceBase sequence, boolean isClosed) {
        this.sequence = sequence;
        this.isClosed = isClosed;
    }
}

