/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.stax;

import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.xqj.core.stax.EmptyLocation;

public class TextXMLStreamReader
implements XMLStreamReader {
    private int cursor = 0;
    private static final int[] CURSOR_LUT = new int[]{7, 4, 8};
    private final String value;

    public TextXMLStreamReader(String value) {
        this.value = value;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Nothing further after END_DOCUMENT.");
        }
        ++this.cursor;
        return this.getEventType();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
    }

    @Override
    public String getElementText() throws XMLStreamException {
        throw new XMLStreamException("not a START_ELEMENT");
    }

    @Override
    public int nextTag() throws XMLStreamException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("hasNext() returns false");
        }
        throw new XMLStreamException("not white space, PROCESSING_INSTRUCTION, START_ELEMENT or END_ELEMENT");
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.cursor < 2;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public boolean isStartElement() {
        return false;
    }

    @Override
    public boolean isEndElement() {
        return false;
    }

    @Override
    public boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public int getAttributeCount() {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public QName getAttributeName(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public String getAttributeNamespace(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public String getAttributeLocalName(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public String getAttributePrefix(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public String getAttributeType(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public String getAttributeValue(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or ATTRIBUTE");
    }

    @Override
    public int getNamespaceCount() {
        throw new IllegalStateException("This is not a START_ELEMENT or END_ELEMENT or NAMESPACE");
    }

    @Override
    public String getNamespacePrefix(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or END_ELEMENT or NAMESPACE");
    }

    @Override
    public String getNamespaceURI(int index) {
        throw new IllegalStateException("This is not a START_ELEMENT or END_ELEMENT or NAMESPACE");
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEventType() {
        return CURSOR_LUT[this.cursor];
    }

    @Override
    public String getText() {
        if (this.getEventType() == 4) {
            return this.value;
        }
        throw new IllegalStateException("Not a valid text state.");
    }

    @Override
    public char[] getTextCharacters() {
        if (this.getEventType() == 4) {
            return this.value.toCharArray();
        }
        throw new IllegalStateException("Not a valid text state.");
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.getEventType() == 4) {
            System.arraycopy(this.getTextCharacters(), sourceStart, target, targetStart, length);
            return length;
        }
        throw new IllegalStateException("Not a valid text state.");
    }

    @Override
    public int getTextStart() {
        if (this.getEventType() == 4) {
            return 0;
        }
        throw new IllegalStateException("Not a valid text state.");
    }

    @Override
    public int getTextLength() {
        if (this.getEventType() == 4) {
            return this.value.length();
        }
        throw new IllegalStateException("Not a valid text state.");
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean hasText() {
        return this.getEventType() == 4;
    }

    @Override
    public Location getLocation() {
        return EmptyLocation.getInstance();
    }

    @Override
    public QName getName() {
        throw new IllegalStateException("not a START_ELEMENT or END_ELEMENT");
    }

    @Override
    public String getLocalName() {
        throw new IllegalStateException("not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
    }

    @Override
    public boolean hasName() {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        return null;
    }

    @Override
    public String getPIData() {
        return null;
    }
}

