/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.ws;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.basex.http.RequestContext;
import org.basex.http.web.WebFunction;
import org.basex.http.web.WebResponse;
import org.basex.http.ws.WebSocket;
import org.basex.http.ws.WsFunction;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.XQData;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;

public final class WsResponse
extends WebResponse {
    private final WebSocket ws;
    private WsFunction func;

    WsResponse(WebSocket ws) {
        super(ws.context);
        this.ws = ws;
    }

    @Override
    protected Expr[] init(WebFunction function, Object data) throws QueryException {
        this.qc = function.module.qc(this.ctx);
        this.qc.jc().type("WebSocket");
        this.ctx.setExternal((Object)this.ws);
        this.ctx.setExternal((Object)new RequestContext(this.ws.request));
        this.func = new WsFunction(function.function, function.module, this.qc);
        this.func.parseAnnotations(this.ctx);
        return this.func.bind(data, this.ws.headers, this.qc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResponse.Response serialize(boolean body) throws QueryException, IOException {
        this.qc.register(this.ctx);
        try {
            ArrayList<Object> values = WsResponse.serialize(this.qc.iter(), this.func.sopts);
            if (!this.func.matches(Annotation._WS_CLOSE, null) && !this.func.matches(Annotation._WS_ERROR, null)) {
                for (Object value : values) {
                    RemoteEndpoint remote = this.ws.getSession().getRemote();
                    if (value instanceof ByteBuffer) {
                        remote.sendBytes((ByteBuffer)value);
                        continue;
                    }
                    remote.sendString((String)value);
                }
            }
        }
        finally {
            this.qc.close();
            this.qc.unregister(this.ctx);
        }
        return WebResponse.Response.STANDARD;
    }

    static ArrayList<Object> serialize(Iter iter, SerializerOptions sopts) throws QueryException, QueryIOException {
        Item item;
        ArrayList<Object> list = new ArrayList<Object>();
        SerialMethod method = (SerialMethod)sopts.get(SerializerOptions.METHOD);
        while ((item = iter.next()) != null) {
            boolean json = method == SerialMethod.BASEX && item instanceof XQData;
            sopts.set(SerializerOptions.METHOD, (Enum)(json ? SerialMethod.JSON : method));
            ArrayOutput ao = item.serialize(sopts);
            list.add(item instanceof Bin ? ByteBuffer.wrap(ao.toArray()) : ao.toString());
        }
        return list;
    }
}

