/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.exceptions.BadRequestException;
import java.io.IOException;
import java.util.Date;
import org.basex.http.webdav.WebDAVCode;
import org.basex.http.webdav.WebDAVFolder;
import org.basex.http.webdav.WebDAVLock;
import org.basex.http.webdav.WebDAVLocks;
import org.basex.http.webdav.WebDAVMetaData;
import org.basex.http.webdav.WebDAVRoot;
import org.basex.http.webdav.WebDAVService;
import org.basex.http.webdav.WebDAVUtils;

abstract class WebDAVResource
implements CopyableResource,
DeletableResource,
MoveableResource,
LockableResource {
    final WebDAVMetaData meta;
    final WebDAVService service;

    WebDAVResource(WebDAVMetaData meta, WebDAVService service) {
        this.meta = meta;
        this.service = service;
    }

    public Object authenticate(String user, String pass) {
        return user;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public String getRealm() {
        return "BaseX";
    }

    public String getUniqueId() {
        return null;
    }

    public String getName() {
        return WebDAVUtils.name(this.meta.path);
    }

    public Date getModifiedDate() {
        return this.meta.mdate;
    }

    public void delete() throws BadRequestException {
        new WebDAVCode<Object>(this){

            @Override
            public void run() throws IOException {
                WebDAVResource.this.remove();
            }
        }.eval();
    }

    public void copyTo(final CollectionResource target, final String name) throws BadRequestException {
        new WebDAVCode<Object>(this){

            @Override
            public void run() throws IOException {
                if (target instanceof WebDAVRoot) {
                    WebDAVResource.this.copyToRoot(name);
                } else if (target instanceof WebDAVFolder) {
                    WebDAVResource.this.copyTo((WebDAVFolder)target, name);
                }
            }
        }.eval();
    }

    public void moveTo(final CollectionResource target, final String name) throws BadRequestException {
        new WebDAVCode<Object>(this){

            @Override
            public void run() throws IOException {
                if (target instanceof WebDAVRoot) {
                    WebDAVResource.this.moveToRoot(name);
                } else if (target instanceof WebDAVFolder) {
                    WebDAVResource.this.moveTo((WebDAVFolder)target, name);
                }
            }
        }.eval();
    }

    public LockResult lock(LockTimeout timeout, LockInfo lockInfo) {
        WebDAVLock lock = WebDAVLocks.get().create(timeout, lockInfo, this.meta);
        return LockResult.success((LockToken)lock.token);
    }

    public LockResult refreshLock(String id) {
        WebDAVLock lock = WebDAVLocks.get().refreshLock(id);
        return lock == null ? LockResult.failed((LockResult.FailureReason)LockResult.FailureReason.PRECONDITION_FAILED) : LockResult.success((LockToken)lock.token);
    }

    public void unlock(String id) {
        WebDAVLocks.get().unlock(id);
    }

    public LockToken getCurrentLock() {
        return WebDAVLocks.get().lockOn(this.meta);
    }

    void remove() throws IOException {
        this.service.remove(this.meta.db, this.meta.path);
    }

    void rename(String name) throws IOException {
        this.service.rename(this.meta.db, this.meta.path, name);
    }

    protected abstract void copyToRoot(String var1) throws IOException;

    protected abstract void copyTo(WebDAVFolder var1, String var2) throws IOException;

    void moveToRoot(String name) throws IOException {
        this.copyToRoot(name);
        this.remove();
    }

    private void moveTo(WebDAVFolder folder, String name) throws IOException {
        if (folder.meta.db.equals(this.meta.db)) {
            this.rename(folder.meta.path + "/" + name);
        } else {
            this.copyTo(folder, name);
            this.remove();
        }
    }
}

