/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.api.client.Session;
import org.basex.core.Command;
import org.basex.core.cmd.XQuery;

final class WebDAVQuery {
    private final String query;
    private final String prolog;
    private final HashMap<String, String> bindings = new HashMap();

    WebDAVQuery(String query) {
        this(query, "");
    }

    WebDAVQuery(String query, String prolog) {
        this.query = query;
        this.prolog = prolog;
    }

    WebDAVQuery variable(String name, String value) {
        this.bindings.put(name, value);
        return this;
    }

    String execute(Session session) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String name : this.bindings.keySet()) {
            sb.append("declare variable $").append(name).append(" external;");
        }
        sb.append(this.prolog).append(this.query);
        XQuery xquery = new XQuery(sb.toString());
        for (Map.Entry<String, String> entry : this.bindings.entrySet()) {
            xquery.bind(entry.getKey(), (Object)entry.getValue());
        }
        return session.execute((Command)xquery);
    }

    public String toString() {
        return this.query;
    }
}

