/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.web;

import java.io.IOException;
import javax.servlet.ServletException;
import org.basex.core.Context;
import org.basex.http.web.WebFunction;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;

public abstract class WebResponse {
    protected final Context ctx;
    protected QueryContext qc;

    protected WebResponse(Context ctx) {
        this.ctx = ctx;
    }

    public final Response create(WebFunction function, Object data, boolean body) throws QueryException, IOException, ServletException {
        StaticFunc sf = function.function;
        try {
            Expr[] args = this.init(function, data);
            this.qc.assign(sf, args);
            this.qc.jc().description("(: " + sf.info + " :) " + this.qc.main);
            this.qc.compile();
            Response response = this.serialize(body);
            return response;
        }
        catch (QueryException ex) {
            if (ex.file() == null) {
                ex.info(sf.info);
            }
            throw ex;
        }
        finally {
            if (this.qc != null) {
                this.qc.close();
            }
        }
    }

    protected abstract Expr[] init(WebFunction var1, Object var2) throws QueryException, IOException;

    protected abstract Response serialize(boolean var1) throws QueryException, IOException, ServletException;

    public static enum Response {
        NONE,
        STANDARD,
        CUSTOM;

    }
}

