/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import javax.servlet.http.HttpSession;
import org.basex.http.HTTPConnection;
import org.basex.query.QueryContext;
import org.basex.util.Performance;
import org.basex.util.Util;

final class RestXqSingleton {
    private static final Object MUTEX = new Object();
    private final String id;
    private final QueryContext qc;
    private final HttpSession session;

    RestXqSingleton(HTTPConnection conn, String id, QueryContext qc) {
        this.qc = qc;
        this.id = id;
        this.session = conn.request.getSession();
        this.queue();
        this.register();
    }

    private void queue() {
        QueryContext oldQc = this.qc();
        if (oldQc != null) {
            oldQc.stop();
            do {
                Performance.sleep((long)1L);
            } while (this.qc() == oldQc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register() {
        Object object = MUTEX;
        synchronized (object) {
            this.session.setAttribute(this.id, (Object)this.qc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        Object object = MUTEX;
        synchronized (object) {
            if (this.qc == this.qc()) {
                this.session.removeAttribute(this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryContext qc() {
        Object object = MUTEX;
        synchronized (object) {
            try {
                Object obj = this.session.getAttribute(this.id);
                return obj instanceof QueryContext ? (QueryContext)obj : null;
            }
            catch (IllegalStateException ex) {
                Util.debug((Throwable)ex);
                return null;
            }
        }
    }
}

