/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqSingleton;
import org.basex.http.web.WebFunction;
import org.basex.http.web.WebResponse;
import org.basex.http.web.WebText;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncOptions;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.http.Method;

final class RestXqResponse
extends WebResponse {
    private final HTTPConnection conn;
    private RestXqFunction func;
    private String message;
    private Integer status;

    RestXqResponse(HTTPConnection conn) {
        super(conn.context);
        this.conn = conn;
    }

    @Override
    protected Expr[] init(WebFunction function, Object data) throws QueryException, IOException {
        this.qc = function.module.qc(this.ctx);
        this.qc.jc().type("RESTXQ");
        this.ctx.setExternal((Object)this.conn.requestCtx);
        this.func = new RestXqFunction(function.function, function.module, this.qc);
        this.func.parseAnnotations(this.ctx);
        return this.func.bind(data, this.conn, this.qc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResponse.Response serialize(boolean body) throws QueryException, IOException, ServletException {
        int size;
        boolean response;
        String forward;
        ArrayOutput cache;
        RestXqSingleton singleton;
        block29: {
            String id = this.func.singleton;
            singleton = id != null ? new RestXqSingleton(this.conn, id, this.qc) : null;
            cache = id != null ? new ArrayOutput() : null;
            forward = null;
            this.qc.register(this.ctx);
            try {
                this.qc.optimize();
                Iter iter = this.qc.iter();
                Item item = iter.next();
                response = item != null;
                SerializerOptions so = this.func.sopts;
                boolean head = true;
                if (item != null && item.type == NodeType.ELEMENT) {
                    ANode node = (ANode)item;
                    if (WebText.T_REST_FORWARD.matches(node)) {
                        ANode ch = node.childIter().next();
                        if (ch == null || ch.type != NodeType.TEXT) {
                            throw this.func.error("'%' element has no string value.", new Object[]{node.name()});
                        }
                        forward = Token.string((byte[])ch.string()).trim();
                        item = iter.next();
                    } else if (WebText.T_REST_RESPONSE.matches(node)) {
                        so = this.build(node);
                        item = iter.next();
                        boolean bl = head = item != null;
                    }
                }
                if (head && this.func.methods.size() == 1 && this.func.methods.contains(Method.HEAD.name())) {
                    throw this.func.error("HEAD method must return a single 'restxq:response' element.", new Object[0]);
                }
                this.conn.sopts(so);
                this.conn.initResponse();
                if (cache == null) {
                    this.conn.timing(this.qc.info);
                }
                if (this.status != null) {
                    int s = this.status;
                    StringBuilder msg = new StringBuilder();
                    if (this.message != null) {
                        msg.append(this.message);
                    }
                    if (s == 302) {
                        if (msg.length() != 0) {
                            msg.append("; ");
                        }
                        msg.append("Location: ").append(this.conn.response.getHeader("Location"));
                    }
                    this.conn.log(s, msg.toString());
                    this.conn.status(s, this.message, null);
                }
                if (item == null || !body) break block29;
                ArrayOutput out = cache != null ? cache : this.conn.response.getOutputStream();
                try (Serializer ser = Serializer.get((OutputStream)out, (SerializerOptions)so);){
                    while (item != null) {
                        ser.serialize(item);
                        item = this.qc.next(iter);
                    }
                }
            }
            catch (Throwable throwable) {
                this.qc.close();
                if (cache != null) {
                    this.conn.timing(this.qc.info);
                }
                this.qc.unregister(this.ctx);
                if (singleton != null) {
                    singleton.unregister();
                }
                if (forward != null) {
                    this.conn.log(204, "");
                    this.conn.forward(forward);
                } else {
                    this.qc.checkStop();
                }
                throw throwable;
            }
        }
        this.qc.close();
        if (cache != null) {
            this.conn.timing(this.qc.info);
        }
        this.qc.unregister(this.ctx);
        if (singleton != null) {
            singleton.unregister();
        }
        if (forward != null) {
            this.conn.log(204, "");
            this.conn.forward(forward);
        } else {
            this.qc.checkStop();
        }
        if (cache != null && (size = (int)cache.size()) > 0) {
            this.conn.response.getOutputStream().write(cache.buffer(), 0, size);
        }
        return this.status != null || forward != null ? WebResponse.Response.CUSTOM : (response ? WebResponse.Response.STANDARD : WebResponse.Response.NONE);
    }

    private SerializerOptions build(ANode response) throws QueryException {
        BasicNodeIter atts = response.attributeIter();
        ANode attr = atts.next();
        if (attr != null) {
            throw this.func.error("Unexpected node: %.", attr);
        }
        SerializerOptions sp = this.func.sopts;
        String cType = null;
        for (ANode node : response.childIter()) {
            if (WebText.T_HTTP_RESPONSE.matches(node)) {
                byte[] sta = null;
                byte[] msg = null;
                for (ANode a : node.attributeIter()) {
                    QNm qnm = a.qname();
                    if (qnm.eq(WebText.Q_STATUS)) {
                        sta = a.string();
                        continue;
                    }
                    if (qnm.eq(WebText.Q_REASON) || qnm.eq(WebText.Q_MESSAGE)) {
                        msg = a.string();
                        continue;
                    }
                    throw this.func.error("Unexpected node: %.", a);
                }
                if (sta != null) {
                    this.status = Token.toInt(sta);
                    this.message = msg != null ? Token.string(msg) : null;
                }
                for (ANode c : node.childIter()) {
                    if (WebText.T_HTTP_HEADER.matches(c)) {
                        byte[] nam = c.attribute(WebText.Q_NAME);
                        byte[] val = c.attribute(WebText.Q_VALUE);
                        if (nam == null || val == null) continue;
                        String key = Token.string((byte[])nam);
                        String value = Token.string((byte[])val);
                        if (key.equalsIgnoreCase("Content-Type")) {
                            cType = value;
                            continue;
                        }
                        this.conn.response.setHeader(key, key.equalsIgnoreCase("Location") ? this.conn.resolve(value) : value);
                        continue;
                    }
                    throw this.func.error("Unexpected node: %.", c);
                }
                continue;
            }
            if (WebText.T_OUTPUT_SERIAL.matches(node)) {
                sp = FuncOptions.serializer((Item)node, (SerializerOptions)this.func.sopts, (InputInfo)this.func.function.info);
                continue;
            }
            throw this.func.error("Unexpected node: %.", node);
        }
        if (this.status == null) {
            this.status = 200;
        }
        if (cType != null) {
            sp.set(SerializerOptions.MEDIA_TYPE, cType);
        }
        return sp;
    }
}

