/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.util.List;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqPathMatcher;
import org.basex.http.web.WebPath;
import org.basex.query.QueryException;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.value.item.QNm;
import org.basex.util.InputInfo;

final class RestXqPath
extends WebPath
implements Comparable<RestXqPath> {
    private final RestXqPathMatcher matcher;

    RestXqPath(String path, InputInfo ii) throws QueryException {
        super(path);
        this.matcher = RestXqPathMatcher.parse(path, ii);
    }

    boolean matches(HTTPConnection conn) {
        return this.matcher.matches(conn.path());
    }

    List<QNm> varNames() {
        return this.matcher.varNames;
    }

    QNmMap<String> values(HTTPConnection conn) {
        return this.matcher.values(conn.path());
    }

    private boolean isTemplate(int s) {
        return this.matcher.varsPos.testBit(s);
    }

    @Override
    public int compareTo(RestXqPath rxp) {
        int sl = this.matcher.segments;
        int d = rxp.matcher.segments - sl;
        if (d != 0) {
            return d;
        }
        for (int s = 0; s < sl; ++s) {
            boolean t2;
            boolean t1 = this.isTemplate(s);
            if (t1 == (t2 = rxp.isTemplate(s))) continue;
            return t1 ? 1 : -1;
        }
        return 0;
    }
}

