/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPStatus;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTCommands;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTRetrieve;
import org.basex.http.rest.RESTRun;
import org.basex.http.rest.RESTSession;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.value.type.NodeType;
import org.basex.util.Strings;
import org.basex.util.options.Options;

final class RESTGet {
    private RESTGet() {
    }

    public static RESTCmd get(RESTSession session) throws IOException {
        HashMap<String, String[]> bindings = new HashMap<String, String[]>();
        String op = null;
        CharSequence input = null;
        String value = null;
        HTTPConnection conn = session.conn;
        SerializerOptions sopts = conn.sopts();
        MainOptions mopts = conn.context.options;
        for (Map.Entry<String, String[]> param : conn.requestCtx.queryStrings().entrySet()) {
            String key = param.getKey();
            CharSequence[] values = param.getValue();
            if (Strings.eqic((String)key, (String[])new String[]{"command", "query", "run"})) {
                if (op != null || values.length > 1) {
                    throw HTTPStatus.MULTIPLE_OPS_X.get(String.join((CharSequence)", ", values));
                }
                op = key;
                input = values[0];
                continue;
            }
            if (key.equalsIgnoreCase("context")) {
                value = values[0];
                continue;
            }
            if (RESTCmd.assign((Options)sopts, param, false) || RESTCmd.assign((Options)mopts, param, false)) continue;
            bindings.put(key, new String[]{values[0], null});
        }
        if (value != null) {
            bindings.put(null, new String[]{value, NodeType.DOCUMENT_NODE.toString()});
        }
        if (op == null) {
            return RESTRetrieve.get(session);
        }
        if (op.equals("query")) {
            return RESTQuery.get(session, input, bindings);
        }
        if (op.equals("run")) {
            return RESTRun.get(session, input, bindings);
        }
        return RESTCommands.get(session, input, true);
    }
}

