/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.basex.BaseXServer;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.Jobs;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.options.Option;

public final class HTTPContext {
    private StaticOptions soptions;
    private Context context;
    private IOException exception;
    private BaseXServer server;
    private static volatile HTTPContext instance;

    private HTTPContext() {
    }

    public static HTTPContext get() {
        if (instance == null) {
            instance = new HTTPContext();
        }
        return instance;
    }

    public Context context() {
        return this.context;
    }

    public void init(StaticOptions sopts) {
        this.soptions = sopts;
    }

    public synchronized Context init(ServletContext sc) throws IOException {
        if (this.context != null) {
            return this.context;
        }
        String webapp = sc.getRealPath("/");
        System.setProperty("org.basex.path", webapp);
        Prop.put((Option)StaticOptions.WEBPATH, (String)webapp);
        Enumeration en = sc.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = sc.getInitParameter(name);
            if (name.startsWith("org.basex.") && name.endsWith("path") && !new File(value).isAbsolute()) {
                Util.debug((Object)(name.toUpperCase(Locale.ENGLISH) + ": " + value), (Object[])new Object[0]);
                value = new IOFile(webapp, value).path();
            }
            Prop.put((String)name, (String)value);
        }
        if (this.soptions == null) {
            this.soptions = new StaticOptions(false);
        } else {
            this.soptions.setSystem();
        }
        this.context = new Context(this.soptions);
        if (!this.soptions.get(StaticOptions.HTTPLOCAL).booleanValue()) {
            try {
                this.server = new BaseXServer(this.context, new String[]{"-D"});
            }
            catch (IOException ex) {
                this.exception = ex;
                throw ex;
            }
        }
        new Jobs(this.context).init();
        return this.context;
    }

    public synchronized IOException exception() {
        return this.exception;
    }

    public synchronized void close() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (IOException ex) {
                Util.stack((Throwable)ex);
            }
            this.server = null;
        }
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
    }
}

