/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceHandlerHelper;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.PreConditionFailedException;
import com.bradmcevoy.http.webdav.LockHandler;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockHandler
implements ExistingEntityHandler {
    private Logger log = LoggerFactory.getLogger(UnlockHandler.class);
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final WebDavResponseHandler responseHandler;

    public UnlockHandler(ResourceHandlerHelper resourceHandlerHelper, WebDavResponseHandler responseHandler) {
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.responseHandler = responseHandler;
    }

    @Override
    public void process(HttpManager httpManager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandlerHelper.process(httpManager, request, response, this);
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandlerHelper.processResource(manager, request, response, r, this);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        LockableResource r = (LockableResource)resource;
        String sToken = request.getLockTokenHeader();
        sToken = LockHandler.parseToken(sToken);
        this.log.debug("unlocking token: " + sToken);
        try {
            r.unlock(sToken);
            this.responseHandler.respondNoContent(resource, response, request);
        }
        catch (PreConditionFailedException ex) {
            this.responseHandler.respondPreconditionFailed(request, response, resource);
        }
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.UNLOCK.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof LockableResource;
    }
}

