/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.PostableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleResource
implements GetableResource,
PostableResource {
    private static final Logger log = LoggerFactory.getLogger(SimpleResource.class);
    final String name;
    final Date modDate;
    final byte[] content;
    final String contentType;
    final String uniqueId;
    final String realm;
    final Resource secureResource;

    public SimpleResource(String name, Date modDate, byte[] content, String contentType, String uniqueId, String realm) {
        this.name = name;
        this.modDate = modDate;
        this.content = content;
        this.contentType = contentType;
        this.uniqueId = uniqueId;
        this.realm = realm;
        this.secureResource = null;
    }

    public SimpleResource(String name, Date modDate, byte[] content, String contentType, String uniqueId, Resource secureResource) {
        this.name = name;
        this.modDate = modDate;
        this.content = content;
        this.contentType = contentType;
        this.uniqueId = uniqueId;
        this.realm = secureResource.getRealm();
        this.secureResource = secureResource;
    }

    @Override
    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException {
        out.write(this.content);
    }

    @Override
    public Long getMaxAgeSeconds(Auth auth) {
        return 60L;
    }

    @Override
    public String getContentType(String accepts) {
        return this.contentType;
    }

    @Override
    public Long getContentLength() {
        return this.content.length;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object authenticate(String user, String password) {
        if (this.secureResource != null) {
            return this.secureResource.authenticate(user, password);
        }
        return user;
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        if (this.secureResource != null) {
            return this.secureResource.authorise(request, method, auth);
        }
        return true;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Date getModifiedDate() {
        return this.modDate;
    }

    @Override
    public String checkRedirect(Request request) {
        return null;
    }

    @Override
    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
        return null;
    }
}

