/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPStatus;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqWadl;
import org.basex.http.web.WebFunction;
import org.basex.http.web.WebModule;
import org.basex.http.ws.WebSocket;
import org.basex.http.ws.WsFunction;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.ann.Annotation;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FNode;
import org.basex.util.Checks;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.http.MediaType;

public final class WebModules {
    private static volatile WebModules instance;
    private final IOFile path;
    private HashMap<String, WebModule> modules = new HashMap();
    private boolean parsed;
    private long access;

    private WebModules(Context ctx) {
        StaticOptions sopts = ctx.soptions;
        String webpath = sopts.get(StaticOptions.WEBPATH);
        String rxqpath = sopts.get(StaticOptions.RESTXQPATH);
        this.path = new IOFile(webpath).resolve(rxqpath);
        int sec = sopts.get(StaticOptions.PARSERESTXQ);
        if (sec >= 0) {
            final int ms = sec == 0 ? 10 : sec * 1000;
            new Timer(true).scheduleAtFixedRate(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    WebModules webModules = WebModules.this;
                    synchronized (webModules) {
                        if (System.currentTimeMillis() - WebModules.this.access >= (long)ms) {
                            WebModules.this.init(true);
                        }
                    }
                }
            }, 0L, 100L);
        }
    }

    public static WebModules get(Context ctx) {
        if (instance == null) {
            instance = new WebModules(ctx);
        }
        return instance;
    }

    public synchronized void init(boolean update) {
        if (!update) {
            this.modules = new HashMap();
        }
        this.parsed = false;
    }

    public FNode wadl(HttpServletRequest request, Context ctx) throws QueryException {
        try {
            return new RestXqWadl(request).create(this.cache(ctx));
        }
        catch (IOException ex) {
            throw new QueryException((Throwable)ex);
        }
    }

    public RestXqFunction restxq(HTTPConnection conn, QNm error) throws QueryException, IOException {
        List<RestXqFunction> funcs = this.find(conn, error, false);
        if (funcs.isEmpty()) {
            return null;
        }
        if (funcs.size() > 1) {
            WebModules.bestSpec(funcs);
        }
        if (funcs.size() > 1) {
            WebModules.bestQf(funcs, conn);
        }
        if (funcs.size() > 1) {
            WebModules.bestConsume(funcs, conn);
        }
        RestXqFunction first = funcs.get(0);
        if (funcs.size() == 1) {
            return first;
        }
        throw first.path == null ? first.error("Multiple services defined for error \"%\":%", error, WebModules.toString(funcs)) : first.error("Multiple services defined for path \"%\":%", first.path, WebModules.toString(funcs));
    }

    private List<RestXqFunction> find(HTTPConnection conn, QNm error, boolean perm) throws QueryException, IOException {
        ArrayList<RestXqFunction> list = new ArrayList<RestXqFunction>();
        for (WebModule module : this.cache(conn.context).values()) {
            for (RestXqFunction func : module.functions()) {
                if (!func.matches(conn, error, perm)) continue;
                list.add(func);
            }
        }
        Collections.sort(list);
        return list;
    }

    public List<RestXqFunction> checks(HTTPConnection conn) throws QueryException, IOException {
        return this.find(conn, null, true);
    }

    public ArrayList<WsFunction> findWs(WebSocket ws, Annotation ann) throws QueryException, IOException {
        ArrayList<WsFunction> funcs = new ArrayList<WsFunction>();
        for (WebModule mod : this.cache(ws.context).values()) {
            for (WsFunction func : mod.wsFunctions()) {
                if (!func.matches(ann, ws.path)) continue;
                funcs.add(func);
            }
        }
        Collections.sort(funcs);
        return funcs;
    }

    public WsFunction websocket(WebSocket ws, Annotation ann) throws QueryException, IOException {
        ArrayList<WsFunction> funcs = this.findWs(ws, ann);
        if (funcs.isEmpty()) {
            return null;
        }
        WsFunction first = funcs.get(0);
        if (funcs.size() == 1) {
            return first;
        }
        throw first.error("Multiple services defined for path \"%\":%", first.path, WebModules.toString(funcs));
    }

    private static String toString(List<? extends WebFunction> funcs) {
        TokenBuilder tb = new TokenBuilder();
        for (WebFunction webFunction : funcs) {
            tb.add(Text.NL).add("- ").add((Object)webFunction);
        }
        return tb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void bestConsume(List<RestXqFunction> funcs, HTTPConnection conn) {
        void var5_8;
        MediaType mt = conn.mediaType();
        ArrayList<MediaType> types = new ArrayList<MediaType>(funcs.size());
        for (RestXqFunction restXqFunction : funcs) {
            types.add(restXqFunction.consumedType(mt));
        }
        MediaType spec = null;
        for (MediaType type : types) {
            if (spec != null && spec.compareTo(type) <= 0) continue;
            spec = type;
        }
        int n = funcs.size() - 1;
        while (var5_8 >= 0) {
            if (!((MediaType)types.get((int)var5_8)).is(spec)) {
                funcs.remove((int)var5_8);
            }
            --var5_8;
        }
    }

    private static void bestSpec(List<RestXqFunction> funcs) {
        for (int l = funcs.size() - 1; l > 0; --l) {
            if (funcs.get(0).compareTo(funcs.get(l)) == 0) continue;
            funcs.remove(l);
        }
    }

    private static void bestQf(List<RestXqFunction> funcs, HTTPConnection conn) {
        ArrayList<MediaType> accepts = conn.accepts();
        double cQf = 0.0;
        double sQf = 0.0;
        for (RestXqFunction func : funcs) {
            for (MediaType accept : accepts) {
                if (func.produces.isEmpty()) {
                    cQf = Math.max(cQf, WebModules.qf(accept, "q"));
                    sQf = 1.0;
                    continue;
                }
                for (MediaType produce : func.produces) {
                    if (!produce.matches(accept)) continue;
                    cQf = Math.max(cQf, WebModules.qf(accept, "q"));
                    sQf = Math.max(sQf, WebModules.qf(produce, "qs"));
                }
            }
        }
        WebModules.bestQf(funcs, accepts, cQf, -1.0);
        if (funcs.size() > 1) {
            WebModules.bestQf(funcs, accepts, cQf, sQf);
        }
    }

    private static void bestQf(List<RestXqFunction> funcs, ArrayList<MediaType> accepts, double clientQf, double serverQf) {
        for (int fl = funcs.size() - 1; fl >= 0; --fl) {
            RestXqFunction func = funcs.get(fl);
            Checks check = accept -> {
                if (func.produces.isEmpty()) {
                    return WebModules.qf(accept, "q") == clientQf;
                }
                Checks checkProduce = produce -> produce.matches(accept) && WebModules.qf(accept, "q") == clientQf && (serverQf == -1.0 || WebModules.qf(produce, "qs") == serverQf);
                return checkProduce.any(func.produces);
            };
            if (check.any(accepts)) continue;
            funcs.remove(fl);
        }
    }

    private static double qf(MediaType type, String factor) {
        String qf = type.parameter(factor);
        return qf != null ? Token.toDouble((byte[])Token.token((String)qf)) : 1.0;
    }

    private synchronized HashMap<String, WebModule> cache(Context ctx) throws QueryException, IOException {
        HashMap<String, WebModule> cache;
        if (this.parsed) {
            cache = this.modules;
        } else {
            if (!this.path.exists()) {
                throw HTTPStatus.NO_RESTXQ_DIRECTORY.get(new Object[0]);
            }
            cache = new HashMap();
            WebModules.parse(ctx, this.path, cache, this.modules);
            this.modules = cache;
            this.parsed = true;
        }
        this.access = System.currentTimeMillis();
        return cache;
    }

    private static void parse(Context ctx, IOFile root, HashMap<String, WebModule> cache, HashMap<String, WebModule> old) throws QueryException, IOException {
        IOFile[] files;
        for (IOFile file : files = root.children()) {
            if (!file.name().equals(".ignore")) continue;
            return;
        }
        for (IOFile file : files) {
            if (file.isDir()) {
                WebModules.parse(ctx, file, cache, old);
                continue;
            }
            String path = file.path();
            if (!file.hasSuffix(IO.XQSUFFIXES)) continue;
            WebModule module = old.get(path);
            if (module == null) {
                module = new WebModule(file);
            }
            module.parse(ctx);
            cache.put(path, module);
        }
    }
}

