/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.web;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.ws.WsFunction;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StaticFunc;
import org.basex.util.Util;

public final class WebModule {
    private final ArrayList<RestXqFunction> functions = new ArrayList();
    private final ArrayList<WsFunction> wsFunctions = new ArrayList();
    private final IOFile file;
    private long time = -1L;
    private String content;

    WebModule(IOFile file) {
        this.file = file;
    }

    void parse(Context ctx) throws QueryException, IOException {
        long ts = this.file.timeStamp();
        if (this.time == ts) {
            return;
        }
        this.time = ts;
        this.content = this.file.string();
        this.functions.clear();
        this.wsFunctions.clear();
        try (QueryContext qc = this.qc(ctx);){
            String name = this.file.name();
            for (StaticFunc sf : qc.functions.funcs()) {
                WsFunction wxq;
                if (sf.expr == null || !name.equals(new IOFile(sf.info.path()).name())) continue;
                RestXqFunction rxf = new RestXqFunction(sf, this, qc);
                if (rxf.parseAnnotations(ctx)) {
                    this.functions.add(rxf);
                }
                if (!(wxq = new WsFunction(sf, this, qc)).parseAnnotations(ctx)) continue;
                this.wsFunctions.add(wxq);
            }
        }
        catch (QueryException ex) {
            if (ctx.soptions.get(StaticOptions.RESTXQERRORS).booleanValue()) {
                throw ex;
            }
            Util.debug((Throwable)ex);
        }
    }

    public ArrayList<RestXqFunction> functions() {
        return this.functions;
    }

    public ArrayList<WsFunction> wsFunctions() {
        return this.wsFunctions;
    }

    public QueryContext qc(Context ctx) throws QueryException {
        QueryContext qc = new QueryContext(ctx);
        qc.parse(this.content, this.file.path());
        return qc;
    }
}

