/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.JobException;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPException;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.QNm;
import org.basex.server.LoginException;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class BaseXServlet
extends HttpServlet {
    private String username;
    private StaticOptions.AuthMethod auth;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        HTTPContext hc = HTTPContext.get();
        try {
            hc.init(config.getServletContext());
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = config.getInitParameter(name);
            if (!name.startsWith("org.basex.")) continue;
            if ((name = name.substring("org.basex.".length())).equalsIgnoreCase(StaticOptions.USER.name())) {
                this.username = value;
                continue;
            }
            if (!name.equalsIgnoreCase(StaticOptions.AUTHMETHOD.name())) continue;
            this.auth = StaticOptions.AuthMethod.valueOf((String)value);
        }
        Context ctx = hc.context();
        if (ctx.soptions.get(StaticOptions.LOGTRACE).booleanValue()) {
            ctx.setExternal((Object)ctx.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HTTPConnection conn = new HTTPConnection(request, response, this.auth);
        try {
            conn.authenticate(this.username);
            this.run(conn);
            return;
        }
        catch (HTTPException ex) {
            conn.error(ex.getStatus(), Util.message((Throwable)ex));
        }
        catch (LoginException ex2) {
            conn.error(401, Util.message((Throwable)ex2));
        }
        catch (QueryException ex3) {
            int code = 500;
            boolean full = conn.context.soptions.get(StaticOptions.RESTXQERRORS);
            QNm qname = ex3.qname();
            if (Token.eq((byte[])qname.uri(), (byte[])QueryText.REST_URI)) {
                Value value = ex3.value();
                if (value instanceof ANum) {
                    code = (int)((ANum)value).itr();
                }
                full = false;
            }
            conn.error(code, full ? Util.message((Throwable)ex3) : ex3.getLocalizedMessage());
        }
        catch (IOException ex4) {
            boolean full2 = conn.context.soptions.get(StaticOptions.RESTXQERRORS);
            conn.error(500, full2 ? Util.message((Throwable)ex4) : ex4.getLocalizedMessage());
        }
        catch (JobException ex5) {
            conn.stop(ex5);
        }
        catch (Exception ex6) {
            String message = Util.bug((Throwable)ex6);
            Util.errln((Object)message, (Object[])new Object[0]);
            conn.error(500, Util.info((Object)"Unexpected error: %", (Object[])new Object[]{message}));
        }
        finally {
            if (!Prop.debug) return;
            Util.errln((Object)("Request: " + request.getMethod() + " " + request.getRequestURL()), (Object[])new Object[0]);
            Object en = request.getHeaderNames();
            while (en.hasMoreElements()) {
                String name9 = (String)en.nextElement();
                Util.errln((Object)("* " + name9 + ": " + request.getHeader(name9)), (Object[])new Object[0]);
            }
            Util.errln((Object)("Response: " + response.getStatus()), (Object[])new Object[0]);
            en = response.getHeaderNames().iterator();
            while (en.hasNext()) {
                String name2 = (String)en.next();
                Util.errln((Object)("* " + name2 + ": " + response.getHeader(name2)), (Object[])new Object[0]);
            }
            return;
        }
    }

    protected abstract void run(HTTPConnection var1) throws Exception;
}

