/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11;

import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.DeleteHelper;
import com.bradmcevoy.http.DeleteHelperImpl;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceHandlerHelper;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHandler
implements ExistingEntityHandler {
    private Logger log = LoggerFactory.getLogger(DeleteHandler.class);
    private final Http11ResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private final ResourceHandlerHelper resourceHandlerHelper;
    private DeleteHelper deleteHelper;

    public DeleteHandler(Http11ResponseHandler responseHandler, HandlerHelper handlerHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        this.resourceHandlerHelper = new ResourceHandlerHelper(handlerHelper, responseHandler);
        this.deleteHelper = new DeleteHelperImpl(handlerHelper);
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.DELETE.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof DeletableResource;
    }

    @Override
    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException, BadRequestException {
        String url = request.getAbsoluteUrl();
        if (url.contains("#")) {
            throw new BadRequestException(null, "Can't delete a resource with a # in the url");
        }
        this.resourceHandlerHelper.process(manager, request, response, this);
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandlerHelper.processResource(manager, request, response, r, this);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        this.log.debug("DELETE: " + request.getAbsoluteUrl());
        DeletableResource r = (DeletableResource)resource;
        if (this.deleteHelper.isLockedOut(request, r)) {
            this.log.info("Could not delete. Is locked");
            this.responseHandler.respondDeleteFailed(request, response, r, Response.Status.SC_LOCKED);
            return;
        }
        this.deleteHelper.delete(r, manager.getEventManager());
        this.log.debug("deleted ok");
        this.responseHandler.respondNoContent(resource, response, request);
    }

    public DeleteHelper getDeleteHelper() {
        return this.deleteHelper;
    }

    public void setDeleteHelper(DeleteHelper deleteHelper) {
        this.deleteHelper = deleteHelper;
    }
}

