/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

public class Range {
    private final long start;
    private final long finish;

    public static Range parse(String s) {
        String[] arr = s.split("-");
        if (arr.length != 2) {
            throw new RuntimeException("Invalid range. Use format start-finish, eg 1000-1500. Range:" + s);
        }
        try {
            Integer start = Integer.parseInt(arr[0]);
            Integer finish = Integer.parseInt(arr[1]);
            return new Range(start.intValue(), finish.intValue());
        }
        catch (Throwable e) {
            throw new RuntimeException("Invalid range. Use format start-finish, eg 1000-1500. Range:" + s);
        }
    }

    public Range(long start, long finish) {
        this.start = start;
        this.finish = finish;
    }

    public long getStart() {
        return this.start;
    }

    public long getFinish() {
        return this.finish;
    }

    public String toString() {
        return "bytes " + this.start + "-" + this.finish;
    }

    public String getRange() {
        return this.start + "-" + this.finish;
    }
}

