/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import java.util.function.Supplier;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.hash.TokenSet;

public final class TokenObjMap<E>
extends TokenSet {
    private Object[] values = new Object[this.capacity()];

    public void put(byte[] key, E val) {
        int i = this.put(key);
        this.values[i] = val;
    }

    public E computeIfAbsent(byte[] key, Supplier<? extends E> func) {
        E value = this.get(key);
        if (value == null) {
            value = func.get();
            this.put(key, value);
        }
        return value;
    }

    public E get(byte[] key) {
        return (E)(key != null ? this.values[this.id(key)] : null);
    }

    public Iterable<E> values() {
        return new ArrayIterator(this.values, 1, this.size);
    }

    @Override
    public int remove(byte[] key) {
        int i = super.remove(key);
        this.values[i] = null;
        return i;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        super.clear();
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Array.copy(this.values, new Object[newSize]);
    }

    @Override
    public String toString() {
        return this.toString((Object[])this.keys, this.values);
    }
}

