/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;

public final class BitArray {
    private static final int WORD_POWER = 6;
    static final int WORD_SIZE = 64;
    private static final long WORD_MASK = -1L;
    private long[] words;
    private int size;

    public BitArray(long[] array, int nr) {
        this.words = array;
        this.size = nr;
    }

    public BitArray() {
        this(new long[1], 0);
    }

    public BitArray(int capacity, boolean set) {
        this(new long[(Math.max(0, capacity - 1) >>> 6) + 1], capacity);
        if (set) {
            int i;
            int p = Math.max(0, capacity - 1) >>> 6;
            for (i = 0; i < p; ++i) {
                this.words[i] = -1L;
            }
            for (i = p << 6; i < capacity; ++i) {
                this.set(i);
            }
        }
    }

    public long[] toArray() {
        int i = this.words.length;
        while (--i >= 0 && this.words[i] == 0L) {
        }
        return Arrays.copyOf(this.words, ++i);
    }

    public int cardinality() {
        int sum = 0;
        int inUse = this.size + 64 - 1 >>> 6;
        for (int i = 0; i < inUse; ++i) {
            sum += Long.bitCount(this.words[i]);
        }
        return sum;
    }

    public boolean get(int i) {
        if (i >= this.size) {
            return false;
        }
        int wi = i >>> 6;
        return (this.words[wi] & 1L << i) != 0L;
    }

    public void set(int i) {
        int wi = i >>> 6;
        if (wi >= this.words.length) {
            this.resize(wi + 1);
        }
        int n = wi;
        this.words[n] = this.words[n] | 1L << i;
        if (i >= this.size) {
            this.size = i + 1;
        }
    }

    public void clear(int i) {
        int wi = i >>> 6;
        if (wi >= this.words.length) {
            this.resize(wi + 1);
        }
        int n = wi;
        this.words[n] = this.words[n] & (1L << i ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int nextFree() {
        int wl = this.words.length;
        for (int w = 0; w < wl; ++w) {
            long word = this.words[w] ^ 0xFFFFFFFFFFFFFFFFL;
            if (word == 0L) continue;
            return (w << 6) + Long.numberOfTrailingZeros(word);
        }
        return wl << 6;
    }

    public int nextSet(int i) {
        if (i >= this.size) {
            return -1;
        }
        int inUse = this.size + 64 - 1 >>> 6;
        int wi = i >>> 6;
        long word = this.words[wi] & -1L << i;
        while (word == 0L) {
            if (++wi == inUse) {
                return -1;
            }
            word = this.words[wi];
        }
        return (wi << 6) + Long.numberOfTrailingZeros(word);
    }

    private void resize(int s) {
        this.words = Arrays.copyOf(this.words, Math.max(this.words.length << 1, s));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (long word : this.words) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(Long.toBinaryString(word));
        }
        return "BitArray[size: " + this.size + ", entries: " + sb + "]";
    }
}

