/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.list.ShortList;

public final class ShrSeq
extends NativeSeq {
    private final short[] values;

    private ShrSeq(short[] values) {
        super(values.length, (Type)AtomType.SHORT);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        short[] values = new short[size];
        for (int s = 0; s < size; ++s) {
            values[s] = (short)in.readNum();
        }
        return ShrSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (short v : this.values) {
            out.writeNum(v);
        }
    }

    @Override
    public Int itemAt(long pos) {
        return new Int(this.values[(int)pos], this.type);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        short[] tmp = new short[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return ShrSeq.get(tmp);
    }

    public short[] toJava() {
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof ShrSeq ? Arrays.equals(this.values, ((ShrSeq)obj).values) : super.equals(obj));
    }

    public static Value get(short[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Int.get(values[0], AtomType.SHORT) : new ShrSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        ShortList tmp = new ShortList(size);
        for (Value value : values) {
            if (value instanceof ShrSeq) {
                tmp.add(((ShrSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add((short)item.itr(null));
            }
        }
        return ShrSeq.get(tmp.finish());
    }
}

