/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.math.BigDecimal;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Token;

public final class DecSeq
extends NativeSeq {
    private final BigDecimal[] values;

    private DecSeq(BigDecimal[] values) {
        super(values.length, (Type)AtomType.DECIMAL);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        BigDecimal[] values = new BigDecimal[size];
        for (int s = 0; s < size; ++s) {
            values[s] = new BigDecimal(Token.string(in.readToken()));
        }
        return DecSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (BigDecimal v : this.values) {
            out.writeToken(Token.chopNumber(Token.token(v.toPlainString())));
        }
    }

    @Override
    public Dec itemAt(long pos) {
        return Dec.get(this.values[(int)pos]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        BigDecimal[] tmp = new BigDecimal[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return DecSeq.get(tmp);
    }

    public BigDecimal[] toJava() {
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof DecSeq ? Array.equals(this.values, ((DecSeq)obj).values) : super.equals(obj));
    }

    private static Value get(BigDecimal[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Dec.get(values[0]) : new DecSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        BigDecimal[] tmp = new BigDecimal[size];
        int t = 0;
        for (Value value : values) {
            if (value instanceof DecSeq) {
                int vs = (int)value.size();
                Array.copyFromStart(((DecSeq)value).values, vs, tmp, t);
                t += vs;
                continue;
            }
            for (Item item : value) {
                tmp[t++] = item.dec(null);
            }
        }
        return DecSeq.get(tmp);
    }
}

