/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.core.MainOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.XMLToken;

public final class Str
extends AStr {
    public static final Str EMPTY = new Str(Token.EMPTY);
    public static final Str SPACE = Str.get(" ");
    public static final Str KEY = Str.get("key");
    public static final Str VALUE = Str.get("value");
    public static final Str TAB = Str.get("\t");
    public static final Str NL = Str.get("\n");
    public static final Str CR = Str.get("\r");

    private Str(byte[] value) {
        this(value, AtomType.STRING);
    }

    private Str(byte[] value, Type type) {
        super(value, type);
    }

    public static Str get(byte[] value) {
        return value.length == 0 ? EMPTY : new Str(value);
    }

    public static Str get(byte[] value, AtomType type) {
        return type == AtomType.STRING ? Str.get(value) : new Str(value, type);
    }

    public static Str get(String value) {
        return Str.get(Token.token(value));
    }

    public static Str get(Object value, QueryContext qc, InputInfo inf) throws QueryException {
        if (value == null) {
            return EMPTY;
        }
        boolean validate = qc.context.options.get(MainOptions.CHECKSTRINGS);
        byte[] bytes = Token.token(value);
        boolean valid = true;
        TokenParser pt = new TokenParser(bytes);
        while (valid && pt.more()) {
            int cp = pt.next();
            valid = XMLToken.valid(cp);
            if (valid || !validate) continue;
            throw QueryError.INVCODE_X.get(inf, Integer.toHexString(cp));
        }
        if (valid) {
            return Str.get(bytes);
        }
        TokenBuilder tb = new TokenBuilder(bytes.length);
        pt.reset();
        while (pt.more()) {
            int cp = pt.next();
            tb.add(XMLToken.valid(cp) ? cp : 65533);
        }
        return Str.get(tb.finish());
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.value;
    }

    public byte[] string() {
        return this.value;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE) ? Bln.get(this != EMPTY) : this, mode);
    }

    @Override
    public String toJava() {
        return Token.string(this.value);
    }
}

