/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.index;

import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.index.IndexNames;
import org.basex.index.IndexType;
import org.basex.index.query.IndexSearch;
import org.basex.index.query.StringToken;
import org.basex.index.stats.Stats;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.index.ValueAccess;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexCosts;
import org.basex.query.util.index.IndexPred;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenIntMap;
import org.basex.util.hash.TokenSet;

public final class IndexInfo {
    public final CompileContext cc;
    public final IndexDb db;
    public final Step step;
    public String optInfo;
    public NameTest test;
    public Expr expr;
    public IndexCosts costs;
    boolean text;
    private IndexPred pred;

    public IndexInfo(IndexDb db, CompileContext cc, Step step) {
        this.cc = cc;
        this.db = db;
        this.step = step;
    }

    public IndexType type(Expr input, IndexType type) {
        IndexType it;
        this.pred = IndexPred.get(input, this);
        if (this.pred == null) {
            return null;
        }
        Step last = this.pred.step();
        if (last == null) {
            return null;
        }
        Data data = this.db.data();
        if (last.test.type == NodeType.TEXT) {
            this.text = true;
        } else if (last.test.type == NodeType.ELEMENT) {
            if (!(data != null && data.meta.uptodate && data.nspaces.isEmpty() && last.test instanceof NameTest)) {
                return null;
            }
            this.test = (NameTest)last.test;
            if (this.test.part() != NamePart.LOCAL) {
                return null;
            }
            Stats stats = data.elemNames.stats(data.elemNames.id(this.test.qname.local()));
            if (stats == null || !stats.isLeaf()) {
                return null;
            }
            this.text = true;
        } else if (last.test.type == NodeType.ATTRIBUTE) {
            this.text = false;
        } else {
            return null;
        }
        IndexType indexType = type != null ? type : (it = this.text ? IndexType.TEXT : IndexType.ATTRIBUTE);
        if (this.text ? it != IndexType.TEXT && it != IndexType.FULLTEXT : it != IndexType.TOKEN && it != IndexType.ATTRIBUTE) {
            return null;
        }
        if (data != null) {
            if (!data.meta.index(it)) {
                return null;
            }
            Step st = this.pred.qname();
            byte[][] qname = null;
            if (st.test instanceof NameTest) {
                NameTest nt = (NameTest)st.test;
                qname = new byte[][]{nt.local, nt.qname == null ? null : nt.qname.uri()};
            }
            if (!new IndexNames(it, data).contains(qname)) {
                return null;
            }
        }
        return it;
    }

    public boolean create(Expr search, IndexType type, boolean trim, InputInfo ii) throws QueryException {
        ValueAccess va;
        if (type == null || search == null) {
            return false;
        }
        Data data = this.db.data();
        if (data == null && !this.enforce()) {
            return false;
        }
        if (search instanceof Value) {
            Item item;
            Iter iter = search.iter(this.cc.qc);
            TokenIntMap cache = new TokenIntMap();
            while ((item = this.cc.qc.next(iter)) != null) {
                if (!item.type.isStringOrUntyped()) {
                    return false;
                }
                byte[] token = item.string(ii);
                if (trim) {
                    token = Token.trim(token);
                }
                int sl = token.length;
                if (type != IndexType.TOKEN && (sl == 0 || data != null && sl > data.meta.maxlen)) {
                    return false;
                }
                if (cache.contains(token)) continue;
                IndexCosts ic = IndexInfo.costs(data, new StringToken(type, token));
                if (ic == null) {
                    return false;
                }
                cache.put(token, ic.results());
                this.costs = IndexCosts.add(this.costs, ic);
            }
            TokenSet tokens = new TokenSet();
            int size = this.test == null ? 0 : -1;
            for (byte[] token : cache) {
                int count = cache.get(token);
                if (count != 0) {
                    tokens.add(token);
                }
                if (size < 0) continue;
                size = count < 0 || type == IndexType.TOKEN && tokens.size() > 1 ? -1 : size + count;
            }
            va = new ValueAccess(ii, tokens, type, this.test, this.db);
            va.exprType.assign(va.seqType(), size);
        } else {
            if (!search.seqType().type.isStringOrUntyped() || search.has(Flag.CTX, Flag.NDT)) {
                return false;
            }
            this.costs = this.enforce() ? IndexCosts.ENFORCE_DYNAMIC : IndexCosts.get(Math.max(1, data.meta.size / 10));
            va = new ValueAccess(ii, search, type, this.test, this.db);
        }
        this.create(va, false, Util.info("apply % index for %", new Object[]{type, search}), ii);
        return true;
    }

    public void create(ParseExpr root, boolean parent, String opt, InputInfo ii) throws QueryException {
        Expr rt;
        if (this.test == null || !parent) {
            rt = root;
        } else {
            Expr st = Step.get(this.cc, (Expr)root, ii, Axis.PARENT, this.test, new Expr[0]);
            rt = Path.get(this.cc, ii, (Expr)root, st);
        }
        this.expr = this.pred.invert(rt);
        this.optInfo = opt;
    }

    public static IndexCosts costs(Data data, IndexSearch search) {
        return data != null ? data.costs(search) : IndexCosts.ENFORCE_STATIC;
    }

    public boolean enforce() {
        return this.cc.qc.context.options.get(MainOptions.ENFORCEINDEX);
    }
}

