/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.HashSet;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.up.ContextModifier;
import org.basex.query.up.DatabaseModifier;
import org.basex.query.up.TransformModifier;
import org.basex.query.up.primitives.Update;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.util.hash.IntObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.StringList;

public final class Updates {
    public final ContextModifier mod;
    public final TokenSet putPaths = new TokenSet();
    private ValueBuilder output;
    private final IntObjMap<MemData> fragmentIDs = new IntObjMap();

    public Updates(boolean transform) {
        this.mod = transform ? new TransformModifier() : new DatabaseModifier();
    }

    public void addData(Data data) {
        this.mod.addData(data);
    }

    public void add(Update up, QueryContext qc) throws QueryException {
        this.mod.add(up, qc);
    }

    public synchronized void addOutput(Value value, QueryContext qc) {
        if (this.output == null) {
            this.output = new ValueBuilder(qc);
        }
        this.output.add(value);
    }

    public synchronized Value output(boolean reset) {
        ValueBuilder vb = this.output;
        if (reset) {
            this.output = null;
        }
        return vb != null ? vb.value() : Empty.VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNode determineDataRef(ANode target, QueryContext qc) throws QueryException {
        MemData data;
        ANode n;
        if (target instanceof DBNode) {
            return (DBNode)target;
        }
        ANode tmp = target;
        BasicNodeIter iter = target.ancestorIter();
        while ((n = iter.next()) != null) {
            tmp = n;
        }
        ANode root = tmp;
        IntObjMap<MemData> intObjMap = this.fragmentIDs;
        synchronized (intObjMap) {
            data = this.fragmentIDs.get(root.id);
            if (data == null) {
                data = (MemData)root.copy(qc).data();
                this.fragmentIDs.put(root.id, data);
            }
        }
        int pre = Updates.preSteps(root, target.id);
        return new DBNode(data, pre);
    }

    public HashSet<Data> prepare(QueryContext qc) throws QueryException {
        HashSet<Data> datas = new HashSet<Data>();
        this.mod.prepare(datas, qc);
        return datas;
    }

    public void apply(QueryContext qc) throws QueryException {
        this.mod.apply(qc);
    }

    public StringList databases() {
        StringList sl = new StringList(1L);
        this.mod.databases(sl);
        return sl;
    }

    public int size() {
        return this.mod.size();
    }

    private static int preSteps(ANode node, int trgID) {
        if (node.id == trgID) {
            return 0;
        }
        int s = 1;
        for (ANode nd : node.attributeIter()) {
            int st = Updates.preSteps(nd, trgID);
            if (st == 0) {
                return s;
            }
            s += st;
        }
        for (ANode nd : node.childIter()) {
            if (trgID - nd.id < 0) break;
            s += Updates.preSteps(nd, trgID);
        }
        return s;
    }
}

