/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.scope;

import java.io.IOException;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.scope.Scope;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public abstract class StaticScope
extends ExprInfo
implements Scope {
    public final StaticContext sc;
    public Expr expr;
    public Value value;
    public InputInfo info;
    public QNm name;
    protected VarScope vs;
    protected boolean compiled;
    protected SeqType declType;
    private byte[] doc = Token.EMPTY;

    StaticScope(StaticContext sc) {
        this.sc = sc;
    }

    public void doc(String string) {
        this.doc = Token.token(string.trim());
    }

    @Override
    public final boolean compiled() {
        return this.compiled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value value(QueryContext qc) throws QueryException {
        if (this.value == null) {
            int fp = this.vs.enter(qc);
            try {
                Value val = this.expr.value(qc);
                if (this.declType != null && !this.declType.instance(val)) {
                    throw QueryError.typeError((Expr)val, this.declType, this.name, this.info, false);
                }
                this.value = val;
            }
            finally {
                VarScope.exit(fp, qc);
            }
        }
        return this.value;
    }

    public final TokenObjMap<TokenList> doc() {
        if (this.doc.length == 0) {
            return null;
        }
        TokenObjMap<TokenList> map = new TokenObjMap<TokenList>();
        TokenBuilder key = new TokenBuilder();
        TokenBuilder tb = new TokenBuilder();
        Runnable add = () -> {
            byte[] k = key.isEmpty() ? Inspect.DOC_TAGS[0] : key.next();
            map.computeIfAbsent(k, TokenList::new).add(tb.trim().next());
        };
        TokenBuilder input = new TokenBuilder();
        try (NewlineInput nli = new NewlineInput(this.doc);){
            while (nli.readLine(input)) {
                String line = input.toString().replaceAll("^\\s*:? *", "");
                if (line.matches("^@\\w+\\s+.*")) {
                    add.run();
                    key.add(line.replaceAll("^@|\\s+.*", ""));
                    line = line.replaceAll("^@\\w+\\s+", "");
                }
                tb.add(line).add(10);
            }
        }
        catch (IOException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
        add.run();
        return map;
    }
}

