/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xslt;

import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import org.basex.query.func.StandardFunc;
import org.basex.util.Reflect;
import org.basex.util.list.StringList;

abstract class XsltFn
extends StandardFunc {
    static final ConcurrentHashMap<String, Templates> MAP = new ConcurrentHashMap();
    private static final StringList SAXONS = new StringList("com.saxonica.config.EnterpriseTransformerFactory", "com.saxonica.config.ProfessionalTransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
    static final String PROCESSOR;
    static final String VERSION;

    XsltFn() {
    }

    static {
        String clazz = TransformerFactory.class.getName();
        String property = System.getProperty(clazz);
        StringList impls = new StringList();
        if (property != null) {
            impls.add(property);
        }
        impls.add(SAXONS);
        Object processor = "Java";
        String version = "1.0";
        for (String impl : impls) {
            if (Reflect.find(impl) == null) continue;
            if (SAXONS.contains(impl)) {
                Class<?> vrsn;
                Object se;
                if (!impl.equals(property)) {
                    System.setProperty(clazz, impl);
                }
                if ((se = Reflect.get(Reflect.field(vrsn = Reflect.find("net.sf.saxon.Version"), "softwareEdition"), null)) != null) {
                    processor = (String)processor + " " + se;
                }
                Object xsl = Reflect.invoke(Reflect.method(vrsn, "getXSLVersionString", new Class[0]), null, new Object[0]);
                processor = "Saxon";
                version = xsl != null ? xsl.toString() : "3.0";
                break;
            }
            processor = impl;
            version = "";
            break;
        }
        PROCESSOR = processor;
        VERSION = version;
    }
}

