/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import java.util.Locale;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.Options;

public final class InspectType
extends StandardFunc {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        Value value = this.arg(0).value(qc);
        InspectOptions options = this.toOptions(this.arg(1), new InspectOptions(), true, qc);
        Mode mode = options.get(InspectOptions.MODE);
        boolean item = options.get(InspectOptions.ITEM);
        SeqType st = null;
        switch (mode) {
            case EXPRESSION: {
                st = this.arg(0).seqType();
                break;
            }
            case VALUE: {
                st = value.seqType();
                break;
            }
            default: {
                for (Item it : value) {
                    SeqType st2 = it.seqType();
                    st = st == null ? st2 : st.union(st2);
                }
                if (st == null) {
                    st = SeqType.EMPTY_SEQUENCE_Z;
                }
                st = st.with(value.seqType().occ);
                SeqType et = this.arg(0).seqType();
                if (!et.instanceOf(st)) break;
                st = et;
            }
        }
        return Str.get((item ? st.type : st).toString());
    }

    public static enum Mode {
        COMPUTED,
        VALUE,
        EXPRESSION;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static class InspectOptions
    extends Options {
        public static final EnumOption<Mode> MODE = new EnumOption<Mode>("mode", Mode.COMPUTED);
        public static final BooleanOption ITEM = new BooleanOption("item", false);
    }
}

