/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;

public final class FnReverse
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Item item;
        final Iter input = this.arg(0).iter(qc);
        final long size = input.size();
        if (size == 0L) {
            return Empty.ITER;
        }
        if (size == 1L) {
            return input;
        }
        if (input.valueIter()) {
            return input.value(qc, null).reverse(qc).iter();
        }
        if (size > -1L) {
            return new Iter(){
                long c;
                {
                    this.c = size;
                }

                @Override
                public Item next() throws QueryException {
                    return --this.c >= 0L ? input.get(this.c) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return input.get(size - i - 1L);
                }

                @Override
                public long size() {
                    return size;
                }
            };
        }
        ValueBuilder vb = new ValueBuilder(qc);
        while ((item = qc.next(input)) != null) {
            vb.addFront(item);
        }
        return vb.value(this).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.arg(0).value(qc).reverse(qc);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        if (input.seqType().zeroOrOne()) {
            return input;
        }
        if (input instanceof Value) {
            return ((Value)input).reverse(cc.qc);
        }
        if (Function.REVERSE.is(input)) {
            return input.arg(0);
        }
        if (Function.TAIL.is(input) && Function.REVERSE.is(input.arg(0))) {
            return cc.function(Function.TRUNK, this.info, input.arg(0).args());
        }
        if (Function.TRUNK.is(input) && Function.REVERSE.is(input.arg(0))) {
            return cc.function(Function.TAIL, this.info, input.arg(0).args());
        }
        if (Function.REPLICATE.is(input) && !input.has(Flag.NDT) && input.arg(0).seqType().zeroOrOne()) {
            return input;
        }
        if (input instanceof List) {
            Expr[] args = input.args();
            int al = args.length;
            ExprList list = new ExprList(al);
            for (int a = al - 1; a >= 0; --a) {
                list.add(cc.function(Function.REVERSE, this.info, args[a]));
            }
            return List.get(cc, input.info(), (Expr[])list.finish());
        }
        if (input instanceof IterFilter) {
            IterFilter filter = (IterFilter)input;
            if (filter.root.size() != -1L) {
                return Filter.get(cc, this.info, cc.function(Function.REVERSE, filter.info(), filter.root), filter.exprs);
            }
        }
        this.adoptType(input);
        return this.embed(cc, false);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode.oneOf(CompileContext.Simplify.DISTINCT, CompileContext.Simplify.COUNT) ? this.arg(0) : this, mode);
    }
}

