/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.function.Supplier;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.collation.CollationItemSet;
import org.basex.query.util.hash.HashItemSet;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;

public class FnDuplicateValues
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Iter values = this.arg(0).atomIter(qc, this.info);
        Collation coll = this.toCollation(this.arg(1), qc);
        Supplier<ItemSet> newSet = () -> coll == null ? new HashItemSet(false, this.info) : new CollationItemSet(coll, this.info);
        final ItemSet set = newSet.get();
        final ItemSet dupl = newSet.get();
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(values)) != null) {
                    if (set.add(item) || !dupl.add(item)) continue;
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr values = this.arg(0);
        SeqType st = values.seqType();
        if (st.zero()) {
            return values;
        }
        AtomType type = st.type.atomic();
        if (type != null) {
            this.exprType.assign(type);
            if (!this.defined(1)) {
                SingletonSeq ss;
                if (values instanceof RangeSeq || values instanceof Range || st.zeroOrOne()) {
                    return Empty.VALUE;
                }
                if (values instanceof SingletonSeq && !st.mayBeArray() && (ss = (SingletonSeq)values).singleItem()) {
                    return type == st.type ? ss.itemAt(0L) : cc.function(Function.DATA, this.info, ss.itemAt(0L));
                }
            }
        }
        return this;
    }
}

