/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.bin.Bit;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.Array;
import org.basex.util.Token;

abstract class BinFn
extends StandardFunc {
    private static final byte[][] BIG = Token.tokens("most-significant-first", "big-endian", "BE");
    private static final byte[][] LITTLE = Token.tokens("least-significant-first", "little-endian", "LE");

    BinFn() {
    }

    final ByteBuffer unpack(QueryContext qc, long len) throws QueryException {
        B64 binary = this.toB64(this.arg(0), qc);
        Item offset = this.arg(1).atomItem(qc, this.info);
        ByteOrder order = this.order(this.arg(2), qc);
        byte[] bytes = binary.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(offset, Int.get(len), bl);
        ByteBuffer bb = ByteBuffer.allocate(bounds[1]).order(order);
        bb.put(bytes, bounds[0], bounds[1]).position(0);
        return bb;
    }

    final Int unpackInteger(QueryContext qc, boolean signed) throws QueryException {
        boolean neg;
        B64 binary = this.toB64(this.arg(0), qc);
        Item offset = this.arg(1).atomItem(qc, this.info);
        Item size = this.arg(2).atomItem(qc, this.info);
        ByteOrder order = this.order(this.arg(3), qc);
        byte[] bytes = binary.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(offset, size, bl);
        int o = bounds[0];
        int l = Math.min(8, bounds[1]);
        if (l == 0) {
            return Int.ZERO;
        }
        byte[] tmp = new byte[8];
        boolean bl2 = neg = signed && (bytes[0] & 0x80) != 0;
        if (order == ByteOrder.BIG_ENDIAN) {
            int s = 8 - l;
            if (neg) {
                for (int i = 0; i < s; ++i) {
                    tmp[i] = -1;
                }
            }
            Array.copy(bytes, o, l, tmp, s);
        } else {
            Array.copyToStart(bytes, o, l, tmp);
            if (neg) {
                for (int i = l; i < 8; ++i) {
                    tmp[i] = -1;
                }
            }
        }
        return Int.get(ByteBuffer.wrap(tmp).order(order).getLong());
    }

    final Item bit(Bit op, QueryContext qc) throws QueryException {
        byte[] bytes2;
        int bl2;
        B64 binary1 = this.toB64OrNull(this.arg(0), qc);
        B64 binary2 = this.toB64OrNull(this.arg(1), qc);
        if (binary1 == null || binary2 == null) {
            return Empty.VALUE;
        }
        byte[] bytes1 = binary1.binary(this.info);
        int bl1 = bytes1.length;
        if (bl1 != (bl2 = (bytes2 = binary2.binary(this.info)).length)) {
            throw QueryError.BIN_DLA_X_X.get(this.info, bl1, bl2);
        }
        if (bl1 == 1) {
            return B64.get(op.eval(bytes1[0], bytes2[0]));
        }
        byte[] tmp = new byte[bl1];
        for (int b = 0; b < bl1; ++b) {
            tmp[b] = op.eval(bytes1[b], bytes2[b]);
        }
        return B64.get(tmp);
    }

    final Item pad(QueryContext qc, boolean left) throws QueryException {
        long octet;
        B64 binary = this.toB64OrNull(this.arg(0), qc);
        long size = this.toLong(this.arg(1), qc);
        long l = octet = this.defined(2) ? this.toLong(this.arg(2), qc) : 0L;
        if (binary == null) {
            return Empty.VALUE;
        }
        byte[] bytes = binary.binary(this.info);
        int bl = bytes.length;
        if (size < 0L) {
            throw QueryError.BIN_NS_X.get(this.info, size);
        }
        if (octet < 0L || octet > 255L) {
            throw QueryError.BIN_OOR_X.get(this.info, octet);
        }
        byte[] tmp = new byte[(int)((long)bl + size)];
        if (left) {
            Arrays.fill(tmp, 0, (int)size, (byte)octet);
            Array.copyFromStart(bytes, bl, tmp, (int)size);
        } else {
            Array.copy(bytes, bl, tmp);
            Arrays.fill(tmp, bl, tmp.length, (byte)octet);
        }
        return B64.get(tmp);
    }

    final ByteOrder order(Expr expr, QueryContext qc) throws QueryException {
        if (expr == Empty.UNDEFINED) {
            return ByteOrder.BIG_ENDIAN;
        }
        byte[] order = this.toToken(expr, qc);
        if (Token.eq(order, BIG)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (Token.eq(order, LITTLE)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw QueryError.BIN_USO_X.get(this.info, new Object[]{order});
    }

    final int[] bounds(Item offset, Item length, int size) throws QueryException {
        int sz;
        Long off = offset.isEmpty() ? null : Long.valueOf(this.toLong(offset));
        Long len = length.isEmpty() ? null : Long.valueOf(this.toLong(length));
        int of = 0;
        if (off != null) {
            if (off < 0L || off > (long)size) {
                throw QueryError.BIN_IOOR_X_X.get(this.info, off, size);
            }
            of = (int)off.longValue();
        }
        if (len != null) {
            if (len < 0L) {
                throw QueryError.BIN_NS_X.get(this.info, off);
            }
            if ((long)of + len > (long)size || len > Integer.MAX_VALUE) {
                throw QueryError.BIN_IOOR_X_X.get(this.info, (long)of + len, size);
            }
            sz = (int)len.longValue();
        } else {
            sz = size - of;
        }
        return new int[]{of, sz};
    }

    final byte[] binary2bytes(byte[] bytes) throws QueryException {
        int bl = bytes.length;
        int r = bl & 7;
        int l = 8 - r & 7;
        int s = bl + 7 >>> 3;
        byte[] tmp = new byte[s];
        for (int i = 0; i < bl; ++i) {
            byte b = bytes[i];
            if (b == 49) {
                int n = l + i >>> 3;
                tmp[n] = (byte)(tmp[n] | 128 >>> (i - r & 7));
                continue;
            }
            if (b == 48) continue;
            throw QueryError.BIN_NNC.get(this.info, new Object[0]);
        }
        return tmp;
    }
}

