/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import org.basex.core.Databases;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.SimpleMap;
import org.basex.query.func.FuncDefinition;
import org.basex.query.func.FuncOptions;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.StringList;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.basex.util.similarity.Levenshtein;

public abstract class StandardFunc
extends Arr {
    public FuncDefinition definition;
    public StaticContext sc;

    protected StandardFunc() {
        super(null, SeqType.ITEM_ZM, new Expr[0]);
    }

    final void init(StaticContext sctx, InputInfo ii, FuncDefinition df, Expr[] args) {
        this.sc = sctx;
        this.info = ii;
        this.definition = df;
        this.exprs = args;
        this.exprType.assign(df.seqType);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        this.checkPerm(cc.qc, this.definition.perm);
        this.simplifyArgs(cc);
        Expr expr = this.opt(cc);
        if (expr != this) {
            return cc.replaceWith(this, expr);
        }
        SeqType st = this.definition.seqType;
        return this.allAreValues(st.occ.max > 1L || st.type instanceof FuncType) && this.isSimple() ? cc.preEval(this) : this;
    }

    protected void simplifyArgs(CompileContext cc) throws QueryException {
        int al = this.args().length;
        for (int a = 0; a < al; ++a) {
            int p = Math.min(a, this.definition.types.length - 1);
            Type type = this.definition.types[p].type;
            if (!type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) continue;
            CompileContext.Simplify mode = type.instanceOf(AtomType.NUMERIC) ? CompileContext.Simplify.NUMBER : CompileContext.Simplify.STRING;
            this.arg(a, arg -> arg.simplifyFor(mode, cc));
        }
    }

    protected Expr opt(CompileContext cc) throws QueryException {
        return this;
    }

    @Override
    public final StandardFunc copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(this.definition.get(this.sc, this.info, StandardFunc.copyAll((CompileContext)cc, vm, (Expr[])this.args())));
    }

    protected final Expr optFirst() {
        return this.optFirst(true, true, null);
    }

    protected final Expr optFirst(boolean occ, boolean atom, Value value) {
        Value expr;
        Expr expr2 = expr = this.defined(0) ? this.arg(0) : value;
        if (expr != null) {
            SeqType st = expr.seqType();
            if (st.zero()) {
                return expr;
            }
            if (occ && st.oneOrMore() && (!atom || !st.mayBeArray())) {
                this.exprType.assign(Occ.EXACTLY_ONE);
            }
        }
        return this;
    }

    protected final byte[] serialize(Iter iter, SerializerOptions sopts, QueryError err, QueryContext qc) throws QueryException {
        try {
            ArrayOutput ao = new ArrayOutput();
            try (Serializer ser = Serializer.get(ao, sopts);){
                Item item;
                while ((item = qc.next(iter)) != null) {
                    ser.serialize(item);
                }
            }
            return new TokenBuilder(ao.finish()).normalize().finish();
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        catch (IOException ex) {
            throw err.get(this.info, ex);
        }
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Flag flag : flags) {
            if (!(flag == Flag.UPD ? this.updating() : this.definition.has(flag))) continue;
            return true;
        }
        Flag[] flgs = Flag.HOF.remove(flags);
        return flgs.length != 0 && super.has(flgs);
    }

    public boolean updating() {
        return this.definition.has(Flag.UPD) || this.sc.mixUpdates && this.definition.has(Flag.HOF);
    }

    @Override
    public boolean vacuous() {
        return this.size() == 0L && !this.has(Flag.UPD);
    }

    public final Expr coerceFunc(Expr expr, CompileContext cc, SeqType declType, SeqType ... argTypes) throws QueryException {
        if (!(expr instanceof FuncItem)) {
            return expr;
        }
        FuncItem func = (FuncItem)expr;
        int al = argTypes.length;
        int fargs = func.arity();
        if (fargs != al) {
            return expr;
        }
        FuncType oldType = func.funcType();
        SeqType[] oldArgs = oldType.argTypes;
        SeqType[] newArgs = new SeqType[al];
        for (int a = 0; a < al; ++a) {
            newArgs[a] = argTypes[a].instanceOf(oldArgs[a]) ? argTypes[a] : oldArgs[a];
        }
        SeqType newDecl = declType.instanceOf(oldType.declType) ? declType : oldType.declType;
        FuncType newType = FuncType.get(newDecl, newArgs);
        return !newType.eq(oldType) ? func.coerceTo(newType, cc.qc, this.info, true) : expr;
    }

    protected final Expr compileData(CompileContext cc) throws QueryException {
        if (cc.dynamic && this.defined(0) && this.arg(0) instanceof Value) {
            Data data = this.toData(cc.qc);
            this.exprType.data(data);
            cc.info("open database \"%\"", data.meta.name);
        }
        return this;
    }

    protected Expr embed(CompileContext cc, boolean skip) throws QueryException {
        Expr[] ops;
        if (this.arg(0) instanceof SimpleMap && ((Checks<Expr>)arg_0 -> StandardFunc.lambda$embed$1(ops = this.arg(0).args(), arg_0)).all((Expr[])ops)) {
            Expr[] args = (Expr[])((ExprList)new ExprList((Expr[])this.args().clone()).set(0, ops[0])).finish();
            Expr fn = this.definition.get(this.sc, this.info, args).optimize(cc);
            return skip ? fn : SimpleMap.get(cc, this.info, (Expr[])((ExprList)new ExprList((Expr[])ops.clone()).set(0, fn)).finish());
        }
        return this;
    }

    protected final ADate toDate(Item item, AtomType type, QueryContext qc) throws QueryException {
        return (ADate)(item.type.isUntyped() ? type.cast(item, qc, this.sc, this.info) : this.checkType(item, type));
    }

    protected final DBNode toDBNode(Item item, boolean mainmem) throws QueryException {
        if (this.checkNoEmpty(item, NodeType.NODE) instanceof DBNode && (mainmem || !item.data().inMemory())) {
            return (DBNode)item;
        }
        throw QueryError.DB_NODE_X.get(this.info, item);
    }

    protected final AStr toStr(Expr expr, QueryContext qc) throws QueryException {
        Item value = expr.atomItem(qc, this.info);
        return value instanceof AStr ? (AStr)value : Str.get(this.toToken(value));
    }

    protected final AStr toZeroStr(Expr expr, QueryContext qc) throws QueryException {
        Item value = expr.atomItem(qc, this.info);
        return value.isEmpty() ? Str.EMPTY : (value instanceof AStr ? (AStr)value : Str.get(this.toToken(value)));
    }

    protected final Collation toCollation(Expr expr, QueryContext qc) throws QueryException {
        return Collation.get(this.toTokenOrNull(expr, qc), qc, this.sc, this.info, QueryError.WHICHCOLL_X);
    }

    protected final Path toPath(Expr expr, QueryContext qc) throws QueryException {
        return this.toPath(this.toString(expr, qc));
    }

    protected final Path toPath(String path) throws QueryException {
        try {
            return path.startsWith("file:/") ? Paths.get(new URI(path)) : Paths.get(path, new String[0]);
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            Util.debug(ex);
            throw QueryError.FILE_INVALID_PATH_X.get(this.info, path);
        }
    }

    protected final IO toIO(Expr expr, QueryContext qc) throws QueryException {
        return this.toIO(this.toString(expr, qc));
    }

    protected final IO toIO(String uri) throws QueryException {
        IO io = this.sc.resolve(uri);
        if (!io.exists()) {
            throw QueryError.WHICHRES_X.get(this.info, io);
        }
        if (io instanceof IOFile && io.isDir()) {
            throw QueryError.RESDIR_X.get(this.info, io);
        }
        return io;
    }

    protected final IOContent toContent(Expr expr, QueryContext qc) throws QueryException {
        Item item = this.toItem(expr, qc);
        return item instanceof Uri ? this.toContent(Token.string(item.string(this.info)), qc) : new IOContent(this.toToken(item));
    }

    protected final IOContent toContent(String uri, QueryContext qc) throws QueryException {
        this.checkPerm(qc, Perm.ADMIN);
        IO io = this.toIO(uri);
        try {
            return new IOContent(io.string(), io.url());
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    protected final String toBaseUri(String path, Options options, StringOption option) {
        String base = options.get(option);
        return base != null && !base.isEmpty() ? base : (path != null && !path.isEmpty() ? path : Token.string(this.sc.baseURI().string()));
    }

    protected final String toEncodingOrNull(Expr expr, QueryError err, QueryContext qc) throws QueryException {
        Item encoding = expr.atomItem(qc, this.info);
        if (encoding.size() == 0L) {
            return null;
        }
        String enc = this.toString(encoding);
        try {
            if (Charset.isSupported(enc)) {
                return Strings.normEncoding(enc);
            }
        }
        catch (IllegalArgumentException ex) {
            Util.debug(ex);
        }
        throw err.get(this.info, new Object[]{QueryError.similar(enc, Levenshtein.similar(Token.token(enc), Strings.encodings()))});
    }

    protected final Item toNodeOrAtomItem(Expr expr, QueryContext qc) throws QueryException {
        Item item = this.toItem(expr, qc);
        return item instanceof ANode ? item : item.atomItem(qc, this.info);
    }

    protected final HashMap<String, String> toOptions(Expr expr, QueryContext qc) throws QueryException {
        return this.toOptions(expr, new Options(), false, qc).free();
    }

    protected final <E extends Options> E toOptions(Expr expr, E options, boolean enforce, QueryContext qc) throws QueryException {
        return new FuncOptions(this.info).assign(expr.item(qc, this.info), options, enforce);
    }

    protected final HashMap<String, Value> toBindings(Expr expr, QueryContext qc) throws QueryException {
        HashMap<String, Value> hm = new HashMap<String, Value>();
        Item item = expr.item(qc, this.info);
        XQMap map = item.size() == 0L ? XQMap.empty() : this.toMap(item);
        map.apply((key, value) -> {
            byte[] k;
            if (key.type.isStringOrUntyped()) {
                k = key.string(null);
            } else {
                QNm qnm = this.toQNm((Item)key);
                TokenBuilder tb = new TokenBuilder();
                if (qnm.uri() != null) {
                    tb.add(123).add(qnm.uri()).add(125);
                }
                k = tb.add(qnm.local()).finish();
            }
            hm.put(Token.string(k), (Value)value);
        });
        return hm;
    }

    protected final Data toData(QueryContext qc) throws QueryException {
        Data data = this.exprType.data();
        return data != null ? data : qc.resources.database(this.toName(this.arg(0), false, QueryError.DB_NAME_X, qc), this.info);
    }

    protected void checkPerm(QueryContext qc, Perm perm) throws QueryException {
        if (perm != Perm.NONE && !qc.context.user().has(perm)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(this.info, new Object[]{perm, this});
        }
    }

    protected final FItem toFunction(Expr expr, int arity, QueryContext qc) throws QueryException {
        return this.toFunction(expr, arity, false, qc);
    }

    protected final FItem toFunction(Expr expr, int arity, boolean updating, QueryContext qc) throws QueryException {
        FItem func = this.checkUp(this.toFunction(expr, qc), updating, this.sc);
        int farity = func.arity();
        if (farity == arity) {
            return func;
        }
        throw QueryError.FUNARITY_X_X.get(this.info, QueryError.arguments(farity), arity);
    }

    protected final String toName(Expr expr, boolean empty, QueryError error, QueryContext qc) throws QueryException {
        String name = this.toString(expr, qc);
        if (empty && name.length() == 0 || Databases.validName(name)) {
            return name;
        }
        throw error.get(this.info, name);
    }

    protected final long toMs(Expr expr, QueryContext qc) throws QueryException {
        Dtm dtm = (Dtm)this.checkType(expr, AtomType.DATE_TIME, qc);
        if (dtm.yea() > 292278993L) {
            throw QueryError.INTRANGE_X.get(this.info, dtm.yea());
        }
        return dtm.toJava().toGregorianCalendar().getTimeInMillis();
    }

    protected final boolean defined(int i) {
        return this.arg(i) != Empty.UNDEFINED;
    }

    protected final boolean dataLock(Expr expr, boolean backup, ASTVisitor visitor) {
        return visitor.lock(() -> {
            String name;
            ArrayList<String> list = new ArrayList<String>(1);
            String string = expr instanceof Str ? Token.string(((Str)expr).string()) : (name = expr instanceof Atm ? Token.string(((Atm)expr).string(null)) : null);
            if (name != null) {
                if (backup) {
                    String db = Databases.name(name);
                    if (db.isEmpty()) {
                        name = db;
                    } else {
                        list.add(db);
                    }
                }
                if (name.isEmpty()) {
                    name = null;
                }
            }
            list.add(name);
            return list;
        });
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof StandardFunc && this.definition == ((StandardFunc)obj).definition && super.equals(obj);
    }

    @Override
    public final String description() {
        return this.definition.toString();
    }

    @Override
    public final void toXml(QueryPlan plan) {
        int undefined = this.undefined();
        if (undefined == 0) {
            plan.add(plan.create(this, "name", this.definition.id()), this.args());
        } else {
            int al = this.args().length;
            QNm[] names = this.definition.paramNames(al);
            ExprList args = new ExprList(al - undefined);
            StringList nms = new StringList(al - undefined);
            for (int a = 0; a < al; ++a) {
                if (!this.defined(a)) continue;
                args.add(this.arg(a));
                nms.add(names[a].toString());
            }
            plan.add(plan.create(this, "name", this.definition.id(), "arg", String.join((CharSequence)", ", (CharSequence[])nms.finish())), (ExprInfo[])args.finish());
        }
    }

    @Override
    public final void toString(QueryString qs) {
        int undefined = this.undefined();
        if (undefined == 0) {
            qs.token(this.definition.id()).params(this.args());
        } else {
            int al = this.args().length;
            QNm[] names = this.definition.paramNames(al);
            Object[] args = new Object[al - undefined];
            boolean gap = false;
            int b = 0;
            for (int a = 0; a < al; ++a) {
                if (this.defined(a)) {
                    args[b++] = gap ? names[a] + " := " + this.arg(a) : this.arg(a);
                    continue;
                }
                gap = true;
            }
            qs.token(this.definition.id()).params(args);
        }
    }

    private int undefined() {
        int c = 0;
        int al = this.args().length;
        for (int a = 0; a < al; ++a) {
            if (this.defined(a)) continue;
            ++c;
        }
        return c;
    }

    private static /* synthetic */ boolean lambda$embed$1(Expr[] ops, Expr op) {
        return op == ops[0] || op.seqType().one() && !op.has(Flag.POS);
    }
}

