/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.basex.data.Data;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Checks;
import org.basex.util.Util;

public abstract class Test
extends ExprInfo {
    public final NodeType type;

    Test(NodeType type) {
        this.type = type;
    }

    public static Test get(NodeType type, QNm name, byte[] defaultNs) {
        NamePart part = type == NodeType.PROCESSING_INSTRUCTION ? NamePart.LOCAL : NamePart.FULL;
        return new NameTest(name, part, type, defaultNs);
    }

    public static Test get(Test ... tests) {
        int tl = tests.length;
        if (tl == 0) {
            return null;
        }
        if (tl == 1) {
            return tests[0];
        }
        ArrayList list = new ArrayList(tl);
        Consumer<Test> add = tst -> {
            if (tst instanceof KindTest) {
                list.removeIf(t -> t instanceof NameTest);
            } else if (tst instanceof NameTest && ((Checks<Test>)t -> t instanceof KindTest).any(list)) {
                return;
            }
            if (!list.contains(tst)) {
                list.add(tst);
            }
        };
        NodeType type = null;
        for (Test test : tests) {
            if (test == null || type != null && type != test.type) {
                return null;
            }
            type = test.type;
            if (test instanceof UnionTest) {
                for (Test t : ((UnionTest)test).tests) {
                    add.accept(t);
                }
                continue;
            }
            add.accept(test);
        }
        return list.size() == 1 ? (Test)list.get(0) : new UnionTest(type, (Test[])list.toArray(Test[]::new));
    }

    public Test optimize(Data data) {
        return this;
    }

    public abstract boolean matches(ANode var1);

    public final boolean matches(Item item) {
        return item instanceof ANode && this.matches((ANode)item);
    }

    public Boolean matches(SeqType seqType) {
        return null;
    }

    public abstract Test copy();

    public boolean instanceOf(Test test) {
        return test instanceof UnionTest ? ((UnionTest)test).instance(this) : this.type.instanceOf(test.type);
    }

    public abstract Test intersect(Test var1);

    public abstract String toString(boolean var1);

    @Override
    public void toXml(QueryPlan plan) {
        throw Util.notExpected();
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token(this.toString(true));
    }
}

