/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import java.util.ArrayList;
import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTFilter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTStringMatch;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.hash.IntObjMap;

public final class FTDistance
extends FTFilter {
    private Expr min;
    private Expr max;

    public FTDistance(InputInfo info, FTExpr expr, Expr min, Expr max, FTUnit unit) {
        super(info, expr, unit);
        this.min = min;
        this.max = max;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.min, this.max);
        super.checkUp();
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        this.min = this.min.compile(cc);
        this.max = this.max.compile(cc);
        return super.compile(cc).optimize(cc);
    }

    @Override
    public FTExpr optimize(CompileContext cc) throws QueryException {
        this.min = this.min.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        this.max = this.max.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        return this;
    }

    @Override
    protected boolean filter(QueryContext qc, FTMatch match, FTLexer lexer) throws QueryException {
        long mn = this.toLong(this.min, qc);
        long mx = this.toLong(this.max, qc);
        FTMatch includes = new FTMatch();
        FTMatch excludes = new FTMatch();
        for (FTStringMatch sm : match) {
            (sm.exclude ? excludes : includes).add(sm);
        }
        int pos = -1;
        ArrayList<FTMatch> matches = new ArrayList<FTMatch>();
        for (FTStringMatch include : includes) {
            if (pos < include.pos) {
                pos = include.pos;
                if (matches.isEmpty()) {
                    matches.add((FTMatch)((Object)new FTMatch().add(include)));
                    continue;
                }
                for (FTMatch ftm : matches) {
                    ftm.add(include);
                }
                continue;
            }
            int ms = matches.size();
            for (int m = 0; m < ms; ++m) {
                FTMatch ftm = (FTMatch)matches.get(m);
                matches.add((FTMatch)new FTMatch().add(ftm).set(ftm.size() - 1, include));
            }
        }
        match.reset();
        block4: for (FTMatch ftm : matches) {
            ftm.sort();
            Iterator iter = ftm.iterator();
            FTStringMatch first = (FTStringMatch)iter.next();
            int end = first.end;
            while (end != -1) {
                if (iter.hasNext()) {
                    FTStringMatch sm = (FTStringMatch)iter.next();
                    int d = this.pos(sm.start, lexer) - this.pos(end, lexer) - 1;
                    end = (long)d < mn || (long)d > mx ? -1 : sm.end;
                    continue;
                }
                match.add(new FTStringMatch(first.start, end, first.pos));
                continue block4;
            }
        }
        return !match.add(excludes).isEmpty();
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.min.has(flags) || this.max.has(flags) || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.min.inlineable(ic) || this.max.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return super.count(var).plus(VarUsage.sum(var, this.min, this.max));
    }

    @Override
    public FTExpr inline(InlineContext ic) throws QueryException {
        Expr mn = this.min.inline(ic);
        Expr mx = this.max.inline(ic);
        if (mn != null) {
            this.min = mn;
        }
        if (mx != null) {
            this.max = mx;
        }
        return ic.inline(this.exprs) || mn != null || mx != null ? this.optimize(ic.cc) : null;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new FTDistance(this.info, (FTExpr)this.exprs[0].copy(cc, (IntObjMap)vm), this.min.copy(cc, vm), this.max.copy(cc, vm), this.unit));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && FTDistance.visitAll(visitor, this.min, this.max);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (FTExpr expr : this.exprs) {
            size += expr.exprSize();
        }
        return this.min.exprSize() + this.max.exprSize() + size;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "distance", this.min + "-" + this.max + " " + this.unit), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.exprs[0]).token("distance").paren(this.min + "-" + this.max + " " + this.unit);
    }
}

