/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import org.basex.io.serial.Serializer;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Function;
import org.basex.query.util.list.AnnList;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class QueryString {
    private static final String NO_SPACE = "|/<([ \n\t";
    private final TokenBuilder tb = new TokenBuilder();

    public QueryString token(char ch) {
        this.tb.add(ch);
        return this;
    }

    public QueryString token(Object token) {
        this.space();
        if (token instanceof ExprInfo) {
            ((ExprInfo)token).toString(this);
        } else if (token instanceof AnnList) {
            ((AnnList)token).toString(this);
        } else {
            byte[] t = Token.token(token);
            this.tb.add(this.last() == ' ' && Token.startsWith(t, 32) ? Token.substring(t, 1) : t);
        }
        return this;
    }

    public QueryString function(Function function, Object ... args) {
        this.token(function.args(args).trim());
        return this;
    }

    public QueryString concat(Object ... tokens) {
        return this.token(Token.concat(tokens));
    }

    public QueryString tokens(Object[] tokens) {
        return this.tokens(tokens, "");
    }

    public QueryString tokens(Object[] tokens, String separator) {
        return this.tokens(tokens, separator, false);
    }

    public QueryString tokens(Object[] tokens, String separator, boolean paren) {
        if (paren) {
            this.tb.add(40);
        } else {
            this.space();
        }
        boolean more = false;
        for (Object token : tokens) {
            if (more) {
                this.tb.add(this.last() == ' ' && Strings.startsWith(separator, ' ') ? separator.substring(1) : separator);
            } else {
                more = true;
            }
            this.token(token);
        }
        if (paren) {
            this.tb.add(41);
        }
        return this;
    }

    public QueryString params(Object[] params) {
        return this.tokens(params, ", ", true);
    }

    public QueryString paren(Object token) {
        return this.braced("(", token, ")");
    }

    public QueryString brace(Object token) {
        return this.braced(" { ", token, " }");
    }

    public QueryString bracket(Object token) {
        return this.braced("[", token, "]");
    }

    public QueryString value(byte[] value) {
        this.tb.add(QueryString.toValue(value));
        return this;
    }

    public QueryString quoted(byte[] value) {
        this.tb.add(QueryString.toQuoted(value));
        return this;
    }

    private QueryString braced(String open, Object token, String close) {
        this.tb.add(open);
        this.token(token);
        byte[] t = Token.token(close);
        this.tb.add(this.last() == ' ' && Token.startsWith(t, 32) ? Token.substring(t, 1) : t);
        return this;
    }

    private QueryString space() {
        if (!Strings.contains(NO_SPACE, this.last())) {
            this.tb.add(32);
        }
        return this;
    }

    private char last() {
        return this.tb.isEmpty() ? (char)' ' : (char)this.tb.get(this.tb.size() - 1);
    }

    public String toString() {
        return this.tb.toString();
    }

    public static byte[] toValue(byte[] value) {
        return Serializer.value(value, '\u0000', true);
    }

    public static byte[] toQuoted(byte[] value) {
        return Serializer.value(value, '\"', true);
    }
}

