/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.locks.Locks;
import org.basex.io.IO;
import org.basex.query.QueryError;
import org.basex.query.QueryParser;
import org.basex.query.QueryProcessor;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.scope.MainModule;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.FuncItem;
import org.basex.query.var.StaticVar;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class QueryInfo {
    private static final int MAX = 0x100000;
    private static final int MAX_LINE = 16384;
    public final AtomicLong parsing = new AtomicLong();
    public final AtomicLong compiling = new AtomicLong();
    public final AtomicLong optimizing = new AtomicLong();
    public final AtomicLong evaluating = new AtomicLong();
    public final AtomicLong serializing = new AtomicLong();
    private final TokenBuilder compile = new TokenBuilder();
    private final TokenBuilder optimize = new TokenBuilder();
    private final TokenBuilder evaluate = new TokenBuilder();
    private final boolean queryinfo;
    private final int runs;
    boolean runtime;
    String query;

    public QueryInfo(Context context) {
        MainOptions mopts = context.options;
        this.queryinfo = mopts.get(MainOptions.QUERYINFO);
        this.runs = Math.max(1, mopts.get(MainOptions.RUNS));
    }

    public void reset() {
        this.compile.reset();
        this.optimize.reset();
        this.evaluate.reset();
    }

    void compInfo(boolean dynamic, String string, Object ... ext) {
        TokenBuilder tb;
        TokenBuilder tokenBuilder = tb = dynamic ? this.optimize : this.compile;
        if (this.queryinfo && tb.size() < 0x100000) {
            TokenList list = new TokenList(ext.length);
            for (Object e : ext) {
                list.add(QueryError.normalize(e, null));
            }
            Object info = Util.info(string, list.finish());
            if (!((String)info).isEmpty()) {
                if (this.runtime) {
                    info = "RUNTIME: " + (String)info;
                    if (Prop.debug) {
                        Util.stack((String)info);
                    }
                }
                tb.add("- ").add((String)info).add(Text.NL);
                if (tb.size() >= 0x100000) {
                    tb.add("- ").add("...").add(Text.NL);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalInfo(String string) {
        if (this.queryinfo) {
            TokenBuilder tokenBuilder = this.evaluate;
            synchronized (tokenBuilder) {
                if (this.evaluate.size() < 0x100000) {
                    this.evaluate.add("- ").add(Token.chop(Token.token(string.replaceAll("\r?\n", "|")), 16384)).add(Text.NL);
                    if (this.evaluate.size() >= 0x100000) {
                        this.evaluate.add("- ").add("...").add(Text.NL);
                    }
                }
            }
        }
    }

    public String toString(QueryProcessor qp, long printed, long hits, Locks locks, boolean success) {
        TokenBuilder tb = new TokenBuilder();
        String total = Performance.getTime(this.parsing.get() + this.compiling.get() + this.optimizing.get() + this.evaluating.get() + this.serializing.get(), this.runs);
        if (this.queryinfo) {
            tb.add(Text.NL);
            if (this.query != null) {
                tb.add(Text.QUERY).add(":").add(Text.NL);
                tb.add(QueryParser.removeComments(this.query, Integer.MAX_VALUE)).add(Text.NL).add(Text.NL);
            }
            if (!this.compile.isEmpty()) {
                tb.add(Text.COMPILING).add(":").add(Text.NL);
                tb.add(this.compile).add(Text.NL);
            }
            if (!this.optimize.isEmpty()) {
                tb.add(Text.OPTIMIZING).add(":").add(Text.NL);
                tb.add(this.optimize).add(Text.NL);
            }
            tb.add(Text.OPTIMIZED_QUERY).add(":").add(Text.NL);
            tb.add(qp.qc.main == null ? qp.qc.functions : QueryInfo.usedDecls(qp.qc.main)).add(Text.NL);
            tb.add(Text.NL);
            if (!this.evaluate.isEmpty()) {
                tb.add(Text.EVALUATING).add(":").add(Text.NL);
                tb.add(this.evaluate).add(Text.NL);
            }
            tb.add(Text.PARSING_CC).add(Performance.getTime(this.parsing.get(), this.runs)).add(Text.NL);
            tb.add(Text.COMPILING_CC).add(Performance.getTime(this.compiling.get(), this.runs)).add(Text.NL);
            tb.add(Text.OPTIMIZING_CC).add(Performance.getTime(this.optimizing.get(), this.runs)).add(Text.NL);
            tb.add(Text.EVALUATING_CC).add(Performance.getTime(this.evaluating.get(), this.runs)).add(Text.NL);
            tb.add(Text.PRINTING_CC).add(Performance.getTime(this.serializing.get(), this.runs)).add(Text.NL);
            tb.add(Text.TOTAL_TIME_CC).add(total).add(Text.NL).add(Text.NL);
            tb.add(Text.NUMBER_CC + hits).add(32).add(hits == 1L ? "Item" : "Items").add(Text.NL);
            int up = qp.updates();
            tb.add(Text.UPDATED_CC + up).add(32).add(up == 1 ? "Item" : "Items").add(Text.NL);
            tb.add(Text.PRINTED_CC).add(Performance.format(printed)).add(Text.NL);
            if (locks != null) {
                tb.add(Text.READ_LOCKING_CC).add(locks.reads).add(Text.NL);
                tb.add(Text.WRITE_LOCKING_CC).add(locks.writes).add(Text.NL);
            }
        }
        if (success) {
            IO baseIO = qp.sc.baseIO();
            String name = baseIO == null ? "" : " \"" + baseIO.name() + "\"";
            tb.add(Text.NL).addExt(Text.QUERY_EXECUTED_X_X, name, total);
        }
        return tb.toString();
    }

    static String usedDecls(MainModule module) {
        final IdentityHashMap map = new IdentityHashMap();
        final StringBuilder sb = new StringBuilder();
        module.visit(new ASTVisitor(){

            @Override
            public boolean staticVar(StaticVar var) {
                if (map.put(var, var) == null) {
                    var.visit(this);
                    sb.append(var).append(Text.NL);
                }
                return true;
            }

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                StaticFunc f = call.func();
                if (map.put(f, f) == null) {
                    f.visit(this);
                    sb.append(f).append(Text.NL);
                }
                return true;
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                if (map.put(scope, scope) == null) {
                    scope.visit(this);
                }
                return true;
            }

            @Override
            public boolean funcItem(FuncItem func) {
                if (map.put(func, func) == null) {
                    func.visit(this);
                }
                return true;
            }
        });
        return sb.append(module).toString();
    }
}

