/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.resource;

import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.StringList;

final class Binaries {
    private final Data data;

    Binaries(Data data) {
        this.data = data;
    }

    synchronized StringList paths(String path, ResourceType type) {
        StringList paths = new StringList();
        Object norm = MetaData.normPath(path);
        if (norm != null && !this.data.inMemory()) {
            IOFile bin = this.data.meta.dir(type);
            IOFile root = new IOFile(bin, (String)norm);
            if (root.isDir()) {
                if (!((String)norm).isEmpty() && !((String)norm).endsWith("/")) {
                    norm = (String)norm + "/";
                }
                for (String relative : root.descendants()) {
                    paths.add(type.dbPath((String)norm + relative));
                }
            } else if (type.filePath(bin, (String)norm).exists()) {
                paths.add(norm);
            }
        }
        return paths.sort(Prop.CASE);
    }

    synchronized void children(String path, boolean dir, TokenObjMap<ResourceType> map) {
        for (ResourceType type : Resources.BINARIES) {
            IOFile bin = this.data.meta.file(path, type);
            if (bin == null) continue;
            boolean value = type == ResourceType.VALUE;
            for (IOFile child : bin.children()) {
                if (dir != child.isDir()) continue;
                map.put(Token.token(value && !dir ? type.dbPath(child.name()) : child.name()), type);
            }
        }
    }

    synchronized boolean isDir(String path, ResourceType type) {
        IOFile bin = this.data.meta.file(path, type);
        return bin != null && bin.isDir();
    }
}

