/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.view.project.ProjectCellEditor;
import org.basex.gui.view.project.ProjectCellRenderer;
import org.basex.gui.view.project.ProjectCommands;
import org.basex.gui.view.project.ProjectDir;
import org.basex.gui.view.project.ProjectNode;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;
import org.basex.util.Util;

final class ProjectTree
extends BaseXTree
implements TreeWillExpandListener,
ProjectCommands {
    private final ProjectView view;

    ProjectTree(final ProjectView view) {
        super(view.gui, new DefaultMutableTreeNode());
        this.view = view;
        this.border(4, 4, 4, 4);
        this.setExpandsSelectedPaths(true);
        ProjectCellRenderer renderer = new ProjectCellRenderer();
        this.setCellRenderer(renderer);
        this.addTreeWillExpandListener(this);
        this.addMouseListener(e -> {
            IOFile file;
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (file = this.selectedFile()) != null && !file.isDir()) {
                view.open(file, "");
            }
        });
        this.setCellEditor(new ProjectCellEditor(this, renderer));
        this.setEditable(true);
        int h = this.getFontMetrics(this.getFont()).getHeight();
        if (h > 16) {
            this.setRowHeight(Math.max(32, h));
        }
        GUIPopupCmd[] edit = new GUIPopupCmd[]{new GUIPopupCmd(Text.DELETE + "...", new BaseXKeys[]{BaseXKeys.DELNEXT}){

            @Override
            public void execute() {
                ProjectNode node = ProjectTree.this.selectedNode();
                GUI gui = view.gui;
                if (BaseXDialog.confirm(gui, Util.info(Text.DELETE_FILE_X, node.file))) {
                    ProjectNode parent = (ProjectNode)node.getParent();
                    if (gui.editor.delete(node.file)) {
                        parent.refresh();
                        ProjectTree.this.setSelectionPath(parent.path());
                        view.refresh();
                    } else {
                        BaseXDialog.error(gui, Util.info(Text.FILE_NOT_DELETED_X, node.file));
                    }
                }
            }

            @Override
            public boolean enabled(GUI main) {
                ProjectNode node = ProjectTree.this.selectedNode();
                return node != null && !node.root();
            }
        }, new GUIPopupCmd(Text.RENAME, new BaseXKeys[]{BaseXKeys.RENAME}){

            @Override
            public void execute() {
                ProjectTree.this.startEditingAtPath(ProjectTree.this.selectedNode().path());
                view.refresh();
            }

            @Override
            public boolean enabled(GUI main) {
                ProjectNode node = ProjectTree.this.selectedNode();
                return node != null && !node.root();
            }
        }, new GUIPopupCmd(Text.NEW_DIR, new BaseXKeys[]{BaseXKeys.NEWDIR}){

            @Override
            public void execute() {
                ProjectNode node = ProjectTree.this.selectedNode();
                ProjectNode dir = node instanceof ProjectDir ? node : (ProjectNode)node.getParent();
                String name = "(" + Text.NEW_DIR + ")";
                IOFile file = new IOFile(dir.file, name);
                int c = 1;
                while (file.exists()) {
                    name = "(" + Text.NEW_DIR + " " + ++c + ")";
                    file = new IOFile(dir.file, name);
                }
                if (file.md()) {
                    dir.expand();
                    String fn = name;
                    new Thread(() -> {
                        Enumeration<TreeNode> children = dir.children();
                        while (children.hasMoreElements()) {
                            ProjectNode child = (ProjectNode)children.nextElement();
                            if (child.file == null || !child.file.name().equals(fn)) continue;
                            TreePath tp = child.path();
                            ProjectTree.this.setSelectionPath(tp);
                            ProjectTree.this.startEditingAtPath(tp);
                            break;
                        }
                    }).start();
                }
            }

            @Override
            public boolean enabled(GUI main) {
                return ProjectTree.this.selectedNode() != null;
            }
        }, null};
        new BaseXPopup(this, view.gui, (GUICommand[])this.commands(edit));
    }

    void init(ProjectNode node) {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).add(node);
        for (int r = 0; r < 2; ++r) {
            this.expandRow(r);
        }
        this.setRootVisible(false);
        this.setSelectionRow(0);
    }

    boolean expand(ProjectNode node, String path) {
        TreePath tp = node.path();
        if (!this.isExpanded(tp)) {
            this.expandPath(tp);
        }
        int ns = node.getChildCount();
        for (int n = 0; n < ns; ++n) {
            ProjectNode ch = (ProjectNode)node.getChildAt(n);
            String np = ch.file.path();
            if (path.equals(np)) {
                TreePath cp = ch.path();
                this.setSelectionPath(cp);
                this.scrollPathToVisible(cp);
                return true;
            }
            if (!path.startsWith(np)) continue;
            return this.expand(ch, path);
        }
        return false;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        Object obj = event.getPath().getLastPathComponent();
        if (obj instanceof ProjectNode) {
            ProjectNode node = (ProjectNode)obj;
            node.expand();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
        Object obj = event.getPath().getLastPathComponent();
        if (obj instanceof ProjectNode) {
            ProjectNode node = (ProjectNode)obj;
            node.collapse();
        }
    }

    ProjectNode selectedNode() {
        Object node;
        TreePath tp = this.selectedPath();
        if (tp != null && (node = tp.getLastPathComponent()) instanceof ProjectNode) {
            return (ProjectNode)node;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.view.refresh();
        this.selectedNode().refresh();
    }

    @Override
    public ProjectView view() {
        return this.view;
    }

    @Override
    public String search() {
        return "";
    }

    @Override
    public IOFile selectedFile() {
        ProjectNode node = this.selectedNode();
        return node != null ? node.file : null;
    }

    @Override
    public List<IOFile> selectedFiles() {
        ArrayList<IOFile> files = new ArrayList<IOFile>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath tp : paths) {
                Object node = tp.getLastPathComponent();
                if (!(node instanceof ProjectNode)) continue;
                files.add(((ProjectNode)node).file);
            }
        }
        return files;
    }

    private TreePath selectedPath() {
        TreePath[] tps = this.getSelectionPaths();
        return tps == null || tps.length > 1 ? null : tps[0];
    }
}

