/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXWindow;

public final class BaseXDSlider
extends BaseXPanel {
    public static final int LABELW = 300;
    private static final int ARROW = 17;
    public final double min;
    public final double max;
    public double currMin;
    public double currMax;
    public boolean itr;
    private final ActionListener listener;
    private double oldMin;
    private double oldMax;
    private int mouX;
    private boolean left;
    private boolean right;
    private boolean center;
    private final boolean log;

    public BaseXDSlider(BaseXWindow win, double min, double max, ActionListener listener) {
        super(win);
        this.listener = listener;
        this.min = min;
        this.max = max;
        this.currMin = min;
        this.currMax = max;
        this.log = StrictMath.log(max) - StrictMath.log(min) > 5.0 && max - min > 100.0;
        this.setOpaque(false);
        this.setFocusable(true);
        BaseXLayout.setWidth(this, 500);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getFont().getSize() + 9));
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseXDSlider.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BaseXDSlider.this.repaint();
            }
        });
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setToolTip();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouX = e.getX();
        Range r = new Range(this);
        this.left = this.mouX >= r.xs && this.mouX <= r.xs + 17;
        this.right = this.mouX >= r.xe && this.mouX <= r.xe + 17;
        this.center = this.mouX + 17 > r.xs && this.mouX < r.xe;
        this.oldMin = this.encode(this.currMin);
        this.oldMax = this.encode(this.currMax);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!(this.left || this.right || this.center)) {
            return;
        }
        Range r = new Range(this);
        double prop = r.dist * (double)(this.mouX - e.getX()) / (double)r.w;
        if (this.left) {
            this.currMin = BaseXDSlider.limit(this.min, this.currMax, this.decode(this.oldMin - prop) - 1.0);
        } else if (this.right) {
            this.currMax = BaseXDSlider.limit(this.currMin, this.max, this.decode(this.oldMax - prop) - 1.0);
        } else {
            this.currMin = BaseXDSlider.limit(this.min, this.max, this.decode(this.oldMin - prop) - 1.0);
            this.currMax = BaseXDSlider.limit(this.min, this.max, this.decode(this.oldMax - prop) - 1.0);
        }
        if (this.itr) {
            this.currMin = (long)this.currMin;
            this.currMax = (long)this.currMax;
        }
        this.listener.actionPerformed(null);
        this.setToolTip();
        this.repaint();
    }

    private void setToolTip() {
        double mn = (double)((long)(this.currMin * 100.0)) / 100.0;
        double mx = (double)((long)(this.currMax * 100.0)) / 100.0;
        this.setToolTipText(BaseXLayout.value(mn) + " - " + BaseXLayout.value(mx));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.left = false;
        this.right = false;
        this.center = false;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.oldMin = this.currMin;
        this.oldMax = this.currMin;
        double diffMin = 0.0;
        double diffMax = 0.0;
        if (BaseXKeys.PREVCHAR.is(e)) {
            diffMin = -1.0;
            diffMax = -1.0;
        } else if (BaseXKeys.NEXTCHAR.is(e)) {
            diffMin = 1.0;
            diffMax = 1.0;
        } else if (BaseXKeys.PREVLINE.is(e)) {
            diffMin = -1.0;
            diffMax = 1.0;
        } else if (BaseXKeys.NEXTLINE.is(e)) {
            diffMin = 1.0;
            diffMax = -1.0;
        } else if (BaseXKeys.LINESTART.is(e)) {
            this.currMin = this.min;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.currMax = this.max;
        }
        if (e.isShiftDown()) {
            diffMin /= 10.0;
            diffMax /= 10.0;
        }
        double dist = this.encode(this.max) - this.encode(this.min);
        diffMin = dist / 20.0 * diffMin;
        diffMax = dist / 20.0 * diffMax;
        if (diffMin != 0.0) {
            this.currMin = BaseXDSlider.limit(this.min, this.currMax, this.decode(Math.max(0.0, this.encode(this.currMin) + diffMin)));
        }
        if (diffMax != 0.0) {
            this.currMax = BaseXDSlider.limit(this.currMin, this.max, this.decode(Math.max(0.0, this.encode(this.currMax) + diffMax)));
        }
        if (this.currMin != this.oldMin || this.currMax != this.oldMax) {
            if (this.itr) {
                if (this.currMin != this.oldMin) {
                    double d = this.currMin = this.currMin > this.oldMin ? Math.max(this.oldMin + 1.0, (double)((long)this.currMin)) : Math.min(this.oldMin - 1.0, (double)((long)this.currMin));
                }
                if (this.currMax != this.oldMax) {
                    this.currMax = this.currMax > this.oldMax ? Math.max(this.oldMax + 1.0, (double)((long)this.currMax)) : Math.min(this.oldMax - 1.0, (double)((long)this.currMax));
                }
            }
            this.listener.actionPerformed(null);
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth() - 300;
        int h = this.getHeight();
        int hc = h / 2;
        int s = 4;
        boolean focus = this.hasFocus();
        g.setColor(GUIConstants.BACK);
        g.fillRect(0, hc - 4, w, 8);
        g.setColor(GUIConstants.TEXT);
        g.drawLine(0, hc - 4, w - 1, hc - 4);
        g.drawLine(0, hc - 4, 0, hc + 4);
        g.setColor(GUIConstants.color2);
        g.drawLine(w - 1, hc - 4, w - 1, hc + 4);
        g.drawLine(0, hc + 4, w, hc + 4);
        Range r = new Range(this);
        BaseXLayout.drawCell(g, r.xs, r.xe + 17, 2, h - 2, false);
        if (r.xs + 17 < r.xe) {
            g.setColor(GUIConstants.color4);
            g.drawLine(r.xs + 17, 3, r.xs + 17, h - 4);
            g.drawLine(r.xe - 1, 3, r.xe - 1, h - 4);
            g.setColor(GUIConstants.BACK);
            if (r.xs + 17 + 2 < r.xe) {
                g.drawLine(r.xs + 17 + 1, 4, r.xs + 17 + 1, h - 5);
                g.drawLine(r.xe, 4, r.xe, h - 5);
            }
            g.drawLine(r.xs + 17 - 1, 4, r.xs + 17 - 1, h - 5);
            g.drawLine(r.xe - 2, 4, r.xe - 2, h - 5);
        }
        Polygon pol = new Polygon(new int[]{r.xs + 11, r.xs + 5, r.xs + 5, r.xs + 11}, new int[]{hc - 5, hc - 1, hc, hc + 5}, 4);
        g.setColor(focus ? GUIConstants.color4 : GUIConstants.gray);
        g.fillPolygon(pol);
        pol.xpoints = new int[]{r.xe + 5, r.xe + 12, r.xe + 12, r.xe + 5};
        g.fillPolygon(pol);
        g.setColor(focus ? GUIConstants.TEXT : GUIConstants.dgray);
        g.drawLine(r.xs + 11, hc - 5, r.xs + 11, hc + 4);
        g.drawLine(r.xs + 11, hc - 5, r.xs + 6, hc - 1);
        g.drawLine(r.xe + 5, hc - 5, r.xe + 5, hc + 4);
        g.drawLine(r.xe + 5, hc - 5, r.xe + 11, hc - 1);
        g.setColor(GUIConstants.BACK);
        g.drawLine(r.xs + 10, hc + 4, r.xs + 6, hc + 1);
        g.drawLine(r.xe + 6, hc + 4, r.xe + 11, hc + 1);
        g.setColor(GUIConstants.TEXT);
        double mn = (double)((long)(this.currMin * 100.0)) / 100.0;
        double mx = (double)((long)(this.currMax * 100.0)) / 100.0;
        g.drawString(BaseXLayout.value(mn) + " - " + BaseXLayout.value(mx), w + 15, h - (h - this.getFont().getSize()) / 2);
    }

    private double encode(double v) {
        return this.log ? StrictMath.log(v + 1.0) : v;
    }

    private double decode(double v) {
        return this.log ? StrictMath.exp(v) - 1.0 : v;
    }

    private static double limit(double mn, double mx, double val) {
        return Math.max(mn, Math.min(mx, val));
    }

    private static class Range {
        final double dist;
        final int xs;
        final int xe;
        final int w;

        Range(BaseXDSlider s) {
            this.w = s.getWidth() - 300 - 34;
            this.dist = s.encode(s.max - s.min);
            this.xs = (int)(s.encode(s.currMin - s.min) * (double)this.w / this.dist);
            this.xe = (s.min == s.max ? this.w : (int)(s.encode(s.currMax - s.min) * (double)this.w / this.dist)) + 17;
        }
    }
}

